% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_functions.r
\name{dfbhist}
\alias{dfbhist}
\title{Hybrid Plot for DFBETAS}
\usage{
dfbhist(
  data,
  varname,
  label,
  cutval = 0.25,
  binwidth = 0.025,
  xlab = "DFBETAS",
  ylab = "Frequency",
  xrange = NULL,
  yrange = NULL,
  nudge_x = NULL,
  nudge_y = NULL
)
}
\arguments{
\item{data}{A data frame of DFBETAS values}

\item{varname}{The name of the variable to plot}

\item{label}{Name of variable that holds the labels that will go with the points}

\item{cutval}{The value that separates the histogram from the individual points.}

\item{binwidth}{The bin width for the histogram part of the display.}

\item{xlab}{Label to put on the x-axis.}

\item{ylab}{Label to put on the y-axis.}

\item{xrange}{Alternative range to plot on the x-axis.}

\item{yrange}{Alternative range to plot on y-axis}

\item{nudge_x}{Vector of values to nudge labels horizontally.}

\item{nudge_y}{Vector of values to nudge labels vertically.}
}
\value{
A ggplot.
}
\description{
Plots a hybrid histogram, dot plot for DFBETAS.  A histogram is plotted
for the observations below \code{cutval}.  Observations above \code{cutval}
are plotted and labelled with individual points.
}
\examples{

data(wvs)
wvs <- na.omit(wvs[,c("country", "secpay", "gini_disp", "democrat")])
lmod <- lm(secpay ~ gini_disp + democrat, data=wvs)
dba <- dfbetas(lmod)
dbd <- wvs
dbd$dfb_ginil <- dba[,2]^2
dbd$dfb_democl <- dba[,3]^2
dfbhist(dbd, "dfb_ginil", "country")

}
