% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_functions.r
\name{qqPoints}
\alias{qqPoints}
\title{Quantile Comparison Data}
\usage{
qqPoints(
  x,
  distribution = "norm",
  line = c("quartiles", "robust", "none"),
  conf = 0.95,
  ...
)
}
\arguments{
\item{x}{vector of values whose quantiles will be calculated.}

\item{distribution}{String giving the theoretical distribution
against which the quantiles of the observed data will be compared.
These need to be functions that have \code{q} and \code{d} functions
in R.  Defaults to "norm".}

\item{line}{String giving the nature of the line that should be drawn
through the points.  If "quartiles", the line is drawn connecting the 25th
and 75th percentiles.  If "robust" a robust linear model is used to fit
the line.}

\item{conf}{Confidence level to be used.}

\item{...}{Other parameters to be passed down to the quantile function.}
}
\value{
A data frame with variables \code{x} observed quantiles,
\code{theo} the theoretical quantiles and \code{lwr} and \code{upr}
the confidence bounds.  The slope and intercept of the line running
through the points are returned as \code{a} and \code{b} as an
attribute of the data.a
}
\description{
Makes data that can be used in quantile comparison plots.
}
\examples{
x <- rchisq(100, 3)
qqdf <- qqPoints(x)
a <- attr(qqdf, "ab")[1]
b <- attr(qqdf, "ab")[2]
l <- min(qqdf$theo) * b + a
u <- max(qqdf$theo) * b + a
library(ggplot2)
ggplot(qqdf, aes(x=theo, y=x)) +
  geom_ribbon(aes(ymin=lwr, ymax=upr), alpha=.15) +
  geom_segment(aes(x=min(qqdf$theo), xend=max(qqdf$theo), y = l, yend=u)) +
  geom_point(shape=1) +
  theme_classic() +
  labs(x="Theoretical Quantiles",
       y="Observed Quantiles")
}
