% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.CompoundDb.R
\name{export.ComboundDb}
\alias{export.ComboundDb}
\title{export.ComboundDb}
\usage{
export.ComboundDb(
  pc.bio.object = NULL,
  pc.directory = NULL,
  path = NULL,
  dbFile = NULL,
  source = NULL,
  source_version = NULL,
  url = NULL,
  source_date = NULL,
  organism = NA_character_,
  get.synonyms = FALSE
)
}
\arguments{
\item{pc.bio.object}{input data.table, generated from 'build.pubchem.bio' or 'build.taxon.metabolome' functions}

\item{pc.directory}{directory from which to load pubchem .Rdata files.  alternatively, provide  R data.tables for ALL cid.\emph{property}.object options defined below.}

\item{path}{valid file path specifying the directory to which the database will be saved.}

\item{dbFile}{valid file name - use .sqlite extension. if NULL, will set to 'pubchem.bio.sqlite'}

\item{source}{default = NULL.  if NULL, will set to 'pubchem.bio'}

\item{source_version}{default = NULL.  if NULL, will set to pubchem.bio version.}

\item{url}{default = NULL. if NULL, will set to "https://cran.r-project.org/web/packages/pubchem.bio/index.html"}

\item{source_date}{default = NULL. if NULL, will set to current date via format(Sys.Date(), format = "\%Y-\%m-\%d")}

\item{organism}{character.  default = NA_character_.  if this is a species specific database, set to species name or NCBI taxonomy ID number.}

\item{get.synonyms}{logical. default = FALSE.  When TRUE, will load the 'cid.synonyms.Rdata' file from the pc.directory, which must be defined. database product will have all synonyms included. If FALSE, synonyms will be an empty list.}
}
\value{
'CompDb' from CompoundDb package.  see vignette('create-compounddb', package = 'CompoundDb')
}
\description{
export pubchem.bio pc.bio syle data.table to a CompoundDb database
}
\details{
takes output from 'build.pubchem.bio' or 'build.taxon.metabolome' functions, reformatting, and converting to a CompoundDb object and database. see see vignette('create-compounddb', package = 'CompoundDb') for more details on the CompoundDb package
}
\author{
Corey Broeckling
}
