% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtnorm.R
\name{dtnorm}
\alias{dtnorm}
\title{Density Function for Truncated Normal Distribution}
\usage{
dtnorm(x, mean = 0, sd = 1, lower = -Inf, upper = Inf)
}
\arguments{
\item{x}{A numeric vector of quantiles at which to evaluate the density.}

\item{mean}{A numeric value specifying the mean of the normal distribution (default is 0).}

\item{sd}{A numeric value specifying the standard deviation of the normal distribution (default is 1, must be positive).}

\item{lower}{A numeric value specifying the lower bound of truncation (default is -Inf).}

\item{upper}{A numeric value specifying the upper bound of truncation (default is Inf).}
}
\value{
A numeric vector of density values corresponding to the input `x`.
The values are normalized to ensure the total probability within the truncation bounds equals 1.
Values outside the truncation bounds are set to 0.
}
\description{
This function calculates the density of a truncated normal distribution at specified points.
}
\examples{
dtnorm(c(-1, 0, 1), mean = 0, sd = 1, lower = -1, upper = 1)
}
