% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_new_functions.R
\name{add_border}
\alias{add_border}
\title{Make an enhanced field layout plot with border rows.}
\usage{
add_border(
  x,
  row_id = "ROW",
  col_id = "COLUMN",
  rep_id = "REP",
  trt_id = "TREATMENT",
  title = "Field layout",
  text_sz = 3,
  axis_title_sz = 12,
  xlab = "Column",
  ylab = "Row",
  border_bg = "grey80",
  text_col = "grey10"
)
}
\arguments{
\item{x}{The input data frame of field book that has row and column 
coordinates of each plot.}

\item{row_id}{The string column identifier for ROW in the input field book.}

\item{col_id}{The string column identifier for COLUMN in the input field book.}

\item{rep_id}{The string column identifier for REP in the input field book.}

\item{trt_id}{The string column identifier for TREATMENT in the input field book.}

\item{title}{The title of the field layout plot.}

\item{text_sz}{The text size to print treatment names on the tiles.}

\item{axis_title_sz}{The text size for axis titles.}

\item{xlab}{A string to label x axis; default is 'Column'.}

\item{ylab}{A string to label y axis; default is 'Row'.}

\item{border_bg}{A string specifying the background color for the border rows.}

\item{text_col}{A string specifying the text color for the border rows.}
}
\value{
A 'ggplot2' graphical object of field layout with border rows around the entire perimeter.
}
\description{
A helper function that adds border rows to the entire perimeter of a
field laid out in a rectangular or square grid. Each experimental plot must
have a coordinate that is specified by row and column numbers in the 
grid layout.
}
\note{
This function works best with input field books generated with the 'FielDHub' package
}
\examples{
\dontshow{if (rlang::is_installed(c("ggplot2", "desplot"))) withAutoprint(\{ # examplesIf}
# Plot a field layout with border rows
library(qrlabelr)

set.seed(123)

add_border(x = data.frame(LOCATION = rep("BAMBEY", 12), 
                         PLOT = c(1001:1012),
                         ROW = c(rep(1, 6), rep(2, 6)),
                         COLUMN = c(1:6, 1:6),
                         REP = rep(1, 12),
                         TREATMENT = sample(paste0("G-", 1:12))),
text_sz = 3)


\dontshow{\}) # examplesIf}
}
