% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_outliers.R
\name{plot_outliers}
\alias{plot_outliers}
\title{Plot Outliers with ggplot2}
\usage{
plot_outliers(data, column, method = "zscore", threshold = 3)
}
\arguments{
\item{data}{A data frame.}

\item{column}{The name of the numeric column to plot.}

\item{method}{"zscore" or "iqr". Defaults to "zscore".}

\item{threshold}{Numeric. Defaults to 3 for zscore, 1.5 for IQR.}
}
\value{
A ggplot object. You can add more layers to it using \code{+}.
}
\description{
Visualizes the distribution of a variable and highlights detected outliers in red.
It combines a boxplot (for context) and jittered points (for individual data visibility).
}
\examples{
library(ggplot2)
df <- data.frame(val = c(rnorm(50), 10)) # 50 normal points and one outlier
plot_outliers(df, "val", method = "iqr")
}
