% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_schema.R
\name{as_evidence}
\alias{as_evidence}
\title{Coerce to Evidence Table}
\usage{
as_evidence(x, ctx = NULL, ...)
}
\arguments{
\item{x}{A data.frame (or tibble) with at least the required evidence
columns.}

\item{ctx}{An optional \link{r4sub_run_context}. If provided, \code{run_id} and
\code{study_id} are filled from the context when missing.}

\item{...}{Additional columns to set (e.g., \code{asset_type = "validation"}).}
}
\value{
A data.frame conforming to the evidence schema.
}
\description{
Takes a data.frame and coerces it into a valid evidence table. Fills in
missing nullable columns with \code{NA} of the correct type and validates
controlled vocabulary columns.
}
\examples{
ctx <- r4sub_run_context("STUDY1", "DEV")
df <- data.frame(
  asset_type = "validation",
  asset_id = "ADSL",
  source_name = "pinnacle21",
  indicator_id = "P21-001",
  indicator_name = "Missing variable",
  indicator_domain = "quality",
  severity = "high",
  result = "fail",
  message = "Variable AGEU missing",
  stringsAsFactors = FALSE
)
ev <- as_evidence(df, ctx = ctx)

}
