% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_fun.R
\name{cluster_on_missing}
\alias{cluster_on_missing}
\title{Cluster on Missingness Patterns}
\usage{
cluster_on_missing(
  data,
  cols_ignore = NULL,
  n_clusters = NULL,
  seed = 42,
  k_neighbors = NULL,
  leiden_resolution = 0.25,
  leiden_objective = "CPM",
  use_snn = TRUE
)
}
\arguments{
\item{data}{A data.frame or matrix (samples × features), may contain \code{NA}.}

\item{cols_ignore}{Character vector of column names to ignore when clustering.}

\item{n_clusters}{Integer; if provided, will run KMeans with this many clusters.
If \code{NULL}, will use Leiden.}

\item{seed}{Integer; random seed for KMeans (or reproducibility in Leiden).}

\item{k_neighbors}{Integer; minimum cluster size for Leiden.
If \code{NULL}, defaults to \code{nrow(data) \%/\% 25}.}

\item{leiden_resolution}{Resolution for Leiden Clustering.}

\item{leiden_objective}{objective}

\item{use_snn}{use snn}
}
\value{
A list with components:
\itemize{
\item \code{clusters}   — integer vector of cluster labels
\item \code{silhouette} — numeric silhouette score, or \code{NA} if not computable
}
}
\description{
Given an R data.frame or matrix with missing values, clusters on the pattern
of missingness and returns cluster labels plus silhouette score.
}
