% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmr.R
\name{get_x1_main_effect}
\alias{get_x1_main_effect}
\title{Extract Main Effect Contribution of the First Predictor Using Elastic Net}
\usage{
get_x1_main_effect(V, X, alpha = 1, lambda = "lambda.min")
}
\arguments{
\item{V}{A numeric matrix of response variables (dimensions: observations x responses).}

\item{X}{A data frame containing all predictor variables. The first column is treated as the target predictor (\code{x1}).}

\item{alpha}{Elastic net mixing parameter (0 = ridge, 1 = lasso). Default is 1.}

\item{lambda}{The value of the regularization parameter to use. Can be \code{"lambda.min"}, \code{"lambda.1se"}, or a specific numeric value. Default is \code{"lambda.min"}.}
}
\value{
A numeric matrix of the same dimensions as \code{V}, where each column contains the estimated main effect contribution of \code{x1} for the corresponding response variable.
}
\description{
This function fits a multivariate elastic net regression model (using \code{glmnet})
to estimate the main effect contribution of the first predictor variable (\code{x1})
in the provided data frame \code{X} for each response variable in \code{V}.
The main effect is forced into the model by setting its penalty factor to zero.
}
\details{
The function constructs a model matrix including all main effects and two-way interactions.
It then fits a multivariate elastic net model using \code{cv.glmnet}, forcing the inclusion of the main effect of \code{x1} by setting its penalty factor to zero.
The resulting coefficients for \code{x1} are used to compute its contribution to the fitted values for each response variable.
}
\examples{
\dontrun{
set.seed(123)
V <- matrix(rnorm(100 * 2), ncol = 2)
X <- data.frame(x1 = rnorm(100), x2 = sample(letters[1:3], 100, TRUE))
result <- get_x1_main_effect(V, X)
}
}
