% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radsafer-package.R
\docType{package}
\name{radsafer-package}
\alias{radsafer}
\alias{radsafer-package}
\title{radsafer: Radiation Safety}
\description{
Provides functions for radiation safety, also known as "radiation protection" and "radiological control". The science of radiation protection is called "health physics" and its engineering functions are called "radiological engineering". Functions in this package cover many of the computations needed by radiation safety professionals. Examples include: obtaining updated calibration and source check values for radiation monitors to account for radioactive decay in a reference source, simulating instrument readings to better understand measurement uncertainty, correcting instrument readings for geometry and ambient atmospheric conditions. Many of these functions are described in Johnson and Kirby (2011, ISBN-13: 978-1609134198). Utilities are also included for developing inputs and processing outputs with radiation transport codes, such as MCNP, a general-purpose Monte Carlo N-Particle code that can be used for neutron, photon, electron, or coupled neutron/photon/electron transport (Werner et. al. (2018) \doi{10.2172/1419730}).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/markhogue/radsafer}
  \item Report bugs at \url{https://github.com/markhogue/radsafer/issues}
}

}
\author{
\strong{Maintainer}: Mark Hogue \email{mark.hogue.chp@gmail.com}

}
\keyword{internal}
