% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStartPointFromPosterior.R
\name{getStartPointFromPosterior}
\alias{getStartPointFromPosterior}
\title{Extract sample from MCMC to use as starting point for another MCMC}
\usage{
getStartPointFromPosterior(handle, dir = NULL)
}
\arguments{
\item{handle}{the output object from the 'ratematrixMCMC' or 'ratematrixJointMCMC' functions.}

\item{dir}{directory with the output files. If 'NULL' (default), then files are read from the directory chosen when running the MCMC chain using the argument 'dir' of the 'ratematrixMCMC' or 'ratematrixJointMCMC' functions (stored on handle). Otherwise function will read files from 'dir'.}
}
\value{
a sample from the posterior of a previous analysis to be used as the 'start' argument for the 'ratematrixMCMC' or 'ratematrixJointMCMC' functions.
}
\description{
Extract last sample from a previous MCMC analysis performed using either 'ratematrixMCMC' or 'ratematrixJointMCMC' to use as the starting point state for another MCMC analysis (also using 'ratematrixMCMC' or 'ratematrixJointMCMC', respectivelly). The number of traits and number of regimes need to be the same between the MCMC runs (the phylogeny and the configuration of the regimes can be changed).
}
\details{
This function can be used to replicate multiple MCMC runs starting from another MCMC. It can also be used to continue a MCMC chain from its last point, because it was was terminated prematurely or did not converge. Also see 'continueMCMC'. Note that 'continueMCMC' will not work with 'ratematrixJointMCMC' analyses, but this function does.
}
\examples{
\donttest{
## Load data
data(anoles)
## Run MCMC. This is just a very short chain.
phy <- mergeSimmap(anoles$phy[[1]], drop.regimes = TRUE) ## Turn simmap into phylo.
traits <- anoles$data[,c(1,2)] ## The continuous traits
## The predictor data.
pred <- setNames(object = as.character(anoles$data$area), nm = rownames(anoles$data))
handle <- ratematrixJointMCMC(data_BM = traits, data_Mk = pred, phy = phy
                              , gen = 1000, dir = tempdir())
## Load posterior distribution, make plots and check the log.
posterior <- readMCMC(handle, burn=0.25, thin=1)
plotRatematrix(posterior)
plotRootValue(posterior)
## Start another MCMC from the last sample of the previous one.
st_pt <- getStartPointFromPosterior(handle = handle)
handle_new <- ratematrixJointMCMC(data_BM = traits, data_Mk = pred, phy = phy
                                  , start = st_pt, gen=1000, dir=tempdir())
post_new <- readMCMC(handle_new, burn=0.25, thin=1)
plotRatematrix(post_new)
plotRootValue(post_new)
}
}
\author{
Daniel S. Caetano and Luke J. Harmon
}
