% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation_storage.R
\name{expand_imputed_data}
\alias{expand_imputed_data}
\title{Expand Reduced Imputed Data to Full Dataset}
\usage{
expand_imputed_data(reduced_data, original_data, vars)
}
\arguments{
\item{reduced_data}{A data.frame containing only the imputed values, as
returned by \code{\link[=reduce_imputed_data]{reduce_imputed_data()}}.}

\item{original_data}{A data.frame containing the original dataset before
imputation, with missing values in the outcome column.}

\item{vars}{A \code{vars} object as created by \code{\link[rbmi:set_vars]{rbmi::set_vars()}}.}
}
\value{
A data.frame containing the full imputed dataset with one complete
dataset per \code{IMPID} value. The structure matches the output of
\code{\link[=get_imputed_data]{get_imputed_data()}}.
}
\description{
Reconstructs the full imputed dataset from a reduced form by merging imputed
values back with the original observed data. This is the inverse operation of
\code{\link[=reduce_imputed_data]{reduce_imputed_data()}}.
}
\details{
For each imputation (identified by \code{IMPID}), this function:
\enumerate{
\item Starts with the original data (observed values)
\item Replaces missing outcome values with the corresponding imputed values
\item Stacks all imputations together
}
}
\examples{
library(rbmi)
library(dplyr)

# Example with package data
data("ADMI", package = "rbmiUtils")
data("ADEFF", package = "rbmiUtils")

# Prepare original data to match ADMI structure
original <- ADEFF |>
  mutate(
    TRT = TRT01P,
    USUBJID = as.character(USUBJID)
  )

vars <- set_vars(
  subjid = "USUBJID",
  visit = "AVISIT",
  group = "TRT",
  outcome = "CHG"
)

# Reduce and then expand
reduced <- reduce_imputed_data(ADMI, original, vars)
expanded <- expand_imputed_data(reduced, original, vars)

# Verify expansion
cat("Original ADMI rows:", nrow(ADMI), "\n")
cat("Expanded rows:", nrow(expanded), "\n")

}
\seealso{
\itemize{
\item \code{\link[rbmi:impute]{rbmi::impute()}} which creates the imputed datasets this function operates on
\item \code{\link[=reduce_imputed_data]{reduce_imputed_data()}} to create the reduced dataset
\item \code{\link[=get_imputed_data]{get_imputed_data()}} to extract imputed data from an rbmi imputation object
}
}
