% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{prepare_prior_params}
\alias{prepare_prior_params}
\title{Prepare Prior Parameters for Covariance Model Prior Distribution}
\usage{
prepare_prior_params(stan_data, covariance, prior_cov, mmrm_initial, same_cov)
}
\arguments{
\item{stan_data}{A list containing the Stan data, to which the prior parameters will be added.}

\item{covariance}{A character string indicating the covariance structure (e.g., "us", "ar1").}

\item{prior_cov}{A character string indicating the prior covariance type (e.g., "default", "lkj").}

\item{mmrm_initial}{A list containing the initial MMRM fit results, which includes
the relevant frequentist estimates.}

\item{same_cov}{A logical indicating whether to use the same covariance structure for all groups.}
}
\value{
Modified \code{stan_data} with prior parameters added.
}
\description{
Based on the \code{covariance} and \code{prior_cov} choices, this function prepares the prior parameters
for the covariance model.
}
\keyword{internal}
