% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_topsoil_thickness_stars.R
\name{read_topsoil_thickness_stars}
\alias{read_topsoil_thickness_stars}
\title{Read ABARES' "Soil Thickness for Australian Areas of Intensive Agriculture of Layer 1" with stars}
\source{
\url{https://anrdl-integration-web-catalog-saxfirxkxt.s3-ap-southeast-2.amazonaws.com/warehouse/staiar9cl__059/staiar9cl__05911a01eg_geo___.zip}.
}
\usage{
read_topsoil_thickness_stars(x = NULL, ...)
}
\arguments{
\item{x}{A file path providing the file with the data to be imported. The
file is assumed to be unarchived (\emph{i.e.}, still zipped). This function does
not provide any checking whether this function is the proper function for
the provided file.  Defaults to \code{NULL}, assuming that the file will be
downloaded in the active \R session.}

\item{...}{Additional arguments passed to \code{\link[stars:st_as_stars]{stars::st_as_stars()}}, for \emph{e.g.},
\code{att} if you wished to set the active category.}
}
\value{
A \CRANpkg{stars} object of the "Soil Thickness for Australian Areas
of Intensive Agriculture of Layer 1".
}
\description{
Read "Soil Thickness for Australian Areas of Intensive Agriculture of Layer
1" data as a \CRANpkg{stars} object.
}
\note{
This function converts a \code{\link[terra:rast]{terra::rast()}} object internally rather than
reading directly from a file.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
st_stars <- read_topsoil_thickness_stars()

plot(st_stars)
\dontshow{\}) # examplesIf}
}
\references{
\url{https://data.agriculture.gov.au/geonetwork/srv/eng/catalog.search#/metadata/faa9f157-8e17-4b23-b6a7-37eb7920ead6}.
}
\seealso{
Other topsoil thickness: 
\code{\link{print_topsoil_thickness_metadata}()},
\code{\link{read_topsoil_thickness_terra}()}
}
\concept{topsoil thickness}
