% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcapConnection.R
\name{redcapConnection}
\alias{redcapConnection}
\alias{print.redcapApiConnection}
\alias{offlineConnection}
\alias{print.redcapOfflineConnection}
\title{Connect to a REDCap Database}
\usage{
redcapConnection(
  url = getOption("redcap_api_url"),
  token,
  config = NULL,
  retries = 5,
  retry_interval = 2^(seq_len(retries)),
  retry_quietly = TRUE,
  ...
)

\method{print}{redcapApiConnection}(x, ...)

offlineConnection(
  meta_data = NULL,
  arms = NULL,
  events = NULL,
  instruments = NULL,
  field_names = NULL,
  mapping = NULL,
  repeat_instrument = NULL,
  users = NULL,
  user_roles = NULL,
  user_role_assignment = NULL,
  dags = NULL,
  dag_assignment = NULL,
  project_info = NULL,
  version = "14.4.0",
  file_repo = NULL,
  records = NULL,
  url = NULL,
  external_coding = list()
)

\method{print}{redcapOfflineConnection}(x, ...)
}
\arguments{
\item{url}{\code{character(1)}. URL for the user's REDCap database API.}

\item{token}{\code{character(1)} REDCap API token}

\item{config}{A list to be passed to \link[curl:handle]{curl::handle_setopt}.  This allows the
user to set additional configurations for the API calls, such as
certificates, SSL version, etc. For the majority of users, this does
not need to be altered.}

\item{retries}{\code{integerish(1)}. Sets the number of attempts to make to the
API if a timeout error is encountered. Must be a positive value.}

\item{retry_interval}{\code{numeric}. Sets the intervals (in seconds) at
which retries are attempted. By default, set at a \code{2^r} where
\code{r} is the \code{r}th retry (ie, 2, 4, 8, 16, ...). For fixed
intervals, provide a single value. Values will be recycled to match
the number of retries.}

\item{retry_quietly}{\code{logical(1)}. When \code{FALSE}, messages will
be shown giving the status of the API calls. Defaults to \code{TRUE}.}

\item{...}{arguments to pass to other methods}

\item{x}{\code{redcapConnection} object to be printed}

\item{meta_data}{Either a \code{character} giving the file from which the
metadata can be read, or a \code{data.frame}.}

\item{arms}{Either a \code{character} giving the file from which the
arms can be read, or a \code{data.frame}.}

\item{events}{Either a \code{character} giving the file from which the
events can be read, or a \code{data.frame}.}

\item{instruments}{Either a \code{character} giving the file from which the
instruments can be read, or a \code{data.frame}.}

\item{field_names}{Either a \code{character} giving the file from which the
field names can be read, or a \code{data.frame}.}

\item{mapping}{Either a \code{character} giving the file from which the
Event Instrument mappings can be read, or a \code{data.frame}.}

\item{repeat_instrument}{Either a \code{character} giving the file from which the
Repeating Instruments and Events settings can be read, or a \code{data.frame}.
Note: The REDCap GUI does not offer a download file of these settings
(at the time of this writing).}

\item{users}{Either a \code{character} giving the file from which the
User settings can be read, or a \code{data.frame}.}

\item{user_roles}{Either a \code{character} giving the file from which the
User Roles can be read, or a \code{data.frame}.}

\item{user_role_assignment}{Either a \code{character} giving the file from which the
User-Role Assignments can be read, or a \code{data.frame}.}

\item{dags}{Either a \code{character} giving the file from which the
Data Access Groups can be read, or a \code{data.frame}.}

\item{dag_assignment}{Either a \code{character} giving the file from which the
Data Access Group Assignments can be read, or a \code{data.frame}.}

\item{project_info}{Either a \code{character} giving the file from which the
Project Information can be read, or a \code{data.frame}. See Details.}

\item{version}{\code{character(1)} giving the instance's REDCap version number.}

\item{file_repo}{Either a \code{character} giving the file from which the
File Repository Listing can be read, or a \code{data.frame}.}

\item{records}{Either a \code{character} giving the file from which the
Records can be read, or a \code{data.frame}. This should be the raw
data as downloaded from the API, for instance. Using labeled or formatted
data is likely to result in errors when passed to other functions.}

\item{external_coding}{Named \code{list} of named \code{character} vectors or a
\code{character} giving the file from which the external coding may
be read. The list is generally obtained from the API using
\code{\link[=exportExternalCoding]{exportExternalCoding()}}. The name of the list element should be
a field name in the data that is of type \code{bioportal} or \code{sql}.
The named vectors are code-label pairings where the value of the
vector is the code and the name is the label. If passing a file name,
it should be a file with the list saved via \code{dput}.}
}
\description{
These methods enable the user to create a connection object
used to access the database.
}
\details{
\code{redcapConnection} objects will retrieve and cache various forms of
project information. This can make metadata, arms, events, etc. available
directly from the \code{redcapConnection} object. The retrieval of these objects
uses the default values of the respective export functions (excepting the
file repository, which uses \code{recursive = TRUE}).

For each of these objects, there are four methods that can be called from
the \code{redcapConnection} object:\tabular{lll}{
   Function type \tab Purpose \tab Example \cr
   \verb{[info_type]} \tab Returns the information from the connection object \tab \code{rcon$metadata()} \cr
   \code{has_[info_type]} \tab Returns a boolean indicating if the information is cached \tab \code{rcon$has_metadata()} \cr
   \code{flush_[info_type]} \tab Purges the information from the connection object \tab \code{rcon$flush_metadata()} \cr
   \code{refresh_[info_type]} \tab Replaces the information with a new call to the API \tab \code{rcon$refresh_metadata()} \cr
}


Information is cached for
\itemize{
\item \code{metadata}
\item \code{arms}
\item \code{events}
\item \code{instruments}
\item \code{fieldnames}
\item \code{mapping} (field-event mappings)
\item \code{repeatInstrumentEvent}
\item \code{users}
\item \code{user_roles}
\item \code{user_role_assignment}
\item \code{dags}
\item \code{dag_assignment}
\item \code{projectInformation}
\item \code{version}
\item \code{fileRepository}
\item \code{externalCoding}
}

There is also a \code{flush_all} and \code{refresh_all} method that will purge
the entire cache and refresh the entire cache, respectively.

The \code{externalCoding} elements relate to the code-label mappings of text fields
with the external validation types (such as \code{sql} fields or text fields
with BioPortal Ontology modules enabled).
\subsection{Specific to API Connections}{

The \code{redcapApiConnection} object also stores the user preferences for
handling repeated attempts to call the API. In the event of a timeout
error or server unavailability, these settings allow a system pause before
attempting another API call. In the event all of the retries fail, the
error message of the last attempt will be returned. These settings may
be altered at any time using the methods \code{rcon$set_retries(r)},
\code{rcon$set_retry_interval(ri)}, and \code{rcon$set_retry_quietly(rq)}.
The argument to these functions have the same requirements as the
corresponding arguments to \code{redcapConnection}.

Tokens are specific to a project, and a token must be created for each
project for which the user wishes to use the API.

Additional Curl option can be set in the \code{config} argument.  See the documentation
for \link[curl:handle]{curl::handle_setopt} for more curl options.
}

\subsection{Specific to Offline Connections}{

"Offline connections" are a tool designed to provide the users without
API privileges with at least a subset of the functionality available to
API users. The offline connections are typically constructed from the
comma separated value (CSV) files downloaded from the REDCap user
interface. Alternatively, data frames may be provided with the
necessary data.

Not all of the components of an offline connection are needed for most
operations. Rather, the object was built to accept the same components
available to the \code{redcapApiConnection} in order to provide a consistent
interface and simplify future development.

The meta data will be required for nearly all operations. For
validating and casting data, the \code{records} data must be provided, and
works best if the data are the raw, unlabeled data downloaded from the
REDCap user interface.

Other components that may prove useful when casting records are the
url, version, events (if the project is longitudinal), and a subset
of the project information. The user is encouraged to review the
vignette for working with offline connections for more details.

With offline connections, the refresh methods have an important difference.
The user may pass the refresh method a file path or data frame which
will be used to replace the existing component. See examples.
}
}
\examples{
\dontrun{
rcon <- redcapConnection(url = [YOUR_REDCAP_URL],
                         token = [API_TOKEN])

exportRecords(rcon)

# Get the complete metadata for the project
rcon$metadata()

# Get the fieldnames for a project
rcon$fieldnames()

# remove a cached value for fieldnames
rcon$flush_fieldnames()
rcon$has_fieldnames()


# Using offline connections

meta_data_file <- "path/to/meta_data_file.csv"
records_file <- "path/to/records_file.csv"
events_file <- "path/to/events_file.csv"

ProjectInfo <- data.frame(project_id = 12345,
                          is_longitudinal = 1)

off_conn <- offlineConnection(meta_data = meta_data_file,
                              records = records_file,
                              project_info = ProjectInfo,
                              version = [YOUR_REDCAP_VERSION_NUMBER],
                              url = [YOUR_REDCAP_URL])

off_conn$metadata()
off_conn$records()
off_conn$projectInformation()
off_conn$version()

# Add or replace the data in the events component.
off_conn$refresh_events(events_file)
off_conn$events()
}

}
\seealso{
For establishing connections using secure token storage. \cr
\code{\link[=unlockREDCap]{unlockREDCap()}} \cr
\code{vignette("redcapAPI-getting-started-connecting", package = "redcapAPI")}\cr

For working with offline connections.
\code{vignette("redcapAPI-offline-connection", package = "redcapAPI")}\cr
\cr
To prepare data for an offline user, see \code{\link[=preserveProject]{preserveProject()}} and
\code{\link[=readPreservedProject]{readPreservedProject()}}.
}
