% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock_request.R
\name{mock_request}
\alias{mock_request}
\title{Create a mock request to use in testing}
\usage{
mock_request(
  url,
  method = "get",
  content = "",
  headers = list(),
  app_location = "",
  remote_address = "123.123.123.123"
)
}
\arguments{
\item{url}{A complete url for the resource the request should ask for,
including querystring if needed}

\item{method}{The request type (get, post, put, etc). Defaults to \code{"get"}}

\item{content}{The content of the request, either a raw vector or a string}

\item{headers}{A list of name-value pairs that defines the request headers}

\item{app_location}{A string giving the first part of the url path that should
be stripped from the path}

\item{remote_address}{The IP address of the presumed sender}
}
\value{
A \code{\link{Request}} object
}
\description{
This function creates a new \code{\link{Request}} for a specific resource defined by a
URL.
}
\examples{
req <- mock_request(
    'http://www.my-fake-website.com/path/to/a/query/?key=value&key2=value2',
    content = 'Some important content'
)

# Get the main address of the URL
req$host

# Get the query string
req$query

# ... etc.

# Cleaning up connections
rm(req)
gc()

}
