% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{session_cookie}
\alias{session_cookie}
\alias{is_session_cookie_settings}
\title{Collect settings for a session cookie}
\usage{
session_cookie(
  name = "reqres",
  expires = NULL,
  max_age = NULL,
  path = NULL,
  secure = NULL,
  same_site = NULL
)

is_session_cookie_settings(x)
}
\arguments{
\item{name}{The name of the cookie}

\item{expires}{A POSIXct object given the expiration time of the cookie}

\item{max_age}{The number of seconds to elapse before the cookie expires}

\item{path}{The URL path this cookie is related to}

\item{secure}{Should the cookie only be send over https}

\item{same_site}{Either \code{"Lax"}, \code{"Strict"}, or \code{"None"} indicating
how the cookie can be send during cross-site requests. If this is set to
\code{"None"} then \code{secure} \emph{must} also be set to \code{TRUE}}

\item{x}{An object to test}
}
\value{
A \code{session_cookie_settings} object that can be used during request
initialisation. Can be cached and reused for all requests in a server
}
\description{
A session cookie is just like any other cookie, but reqres treats this one
different, parsing it's value and making it available in the \verb{$session}
field. However, the same settings as any other cookies applies and can be
given during request initialisation using this function.
}
\note{
As opposed to regular cookies the session cookie is forced to be HTTP
only which is why this argument is missing.
}
\examples{
session_cookie <- session_cookie()

rook <- fiery::fake_request("http://example.com")

# A key must be provided for session_cookie to be used
Request$new(rook, key = random_key(), session_cookie = session_cookie)

}
