% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhymer.R
\name{get_other_related}
\alias{get_other_related}
\title{Get data for words that are related according to a supplied code.}
\usage{
get_other_related(word = "test", code = "jja", return_type = "df", limit = 10)
}
\arguments{
\item{word}{to get similarly spelled words with.}

\item{code}{related word code from http://www.datamuse.com/api/.}

\item{return_type}{type to return. Options are:
\itemize{
\item 'df' for data.frame.
\item 'word' for a single word.
\item 'random_word' or 'random word' or 'rand' for a random word.
\item 'vector' for a vector of words.
}}

\item{limit}{max number of words to return.}
}
\value{
data with words that are related.
}
\description{
Get data for words that are related according to a supplied code.
}
\examples{
get_other_related("test", code = "jja", limit = 3)

get_other_related("test", code = "cns", limit = 10)
}
