% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GctMatrix.R
\name{GctMatrix}
\alias{GctMatrix}
\title{Create a GctMatrix object}
\usage{
GctMatrix(matrix, desc)
}
\arguments{
\item{matrix}{A numeric matrix}

\item{desc}{Character vector of feature description, length must equal nrow of the matrix}
}
\value{
A \code{GctMatrix} object
}
\description{
Create a GctMatrix object
}
\examples{
m1 <- matrix(1:6, nrow=3, dimnames=list(sprintf("G\%d", 1:3), sprintf("S\%d", 1:2)))
m2 <- matrix(c(9:7, 12:10), nrow=3, dimnames=list(sprintf("G\%d", 3:1), sprintf("S\%d", 3:4)))
gm1 <- GctMatrix(m1, desc=sprintf("Gene\%d", 1:3))
gm2 <- GctMatrix(m2, desc=sprintf("Gene\%d", 3:1))
print(gm1)
print(gm2)
}
