% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_trimmed_lines.R
\name{read_trimmed_lines}
\alias{read_trimmed_lines}
\title{Read lines, thereby trimming empty spaces around the strings and removing empty lines}
\usage{
read_trimmed_lines(file, skipNul = TRUE, ...)
}
\arguments{
\item{file}{A text file}

\item{skipNul}{Skip NULL line (passed to \code{readLines})}

\item{...}{Other paratmers than \code{skipNul} passed to readLines}
}
\value{
Character vector of trimmed, non-empty lines.
}
\description{
Read lines, thereby trimming empty spaces around the strings and removing empty lines
}
\examples{
lines <- "  ABC \n\tHBV\n\nFCB  \n\n"
trimmedLines <- read_trimmed_lines(textConnection(lines))
stopifnot(identical(trimmedLines, c("ABC", "HBV", "FCB")))
}
