% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeStrList.R
\name{strList2DataFrame}
\alias{strList2DataFrame}
\title{Format a string list into a data.frame}
\usage{
strList2DataFrame(strList, colnames = names(strList), index = FALSE)
}
\arguments{
\item{strList}{A list of character strings. Other data types (e.g. factors) are converted to strings.}

\item{colnames}{Column names of the resulting data.frame, by default the names of the list}

\item{index}{Logical value, whether the row.names attribute of the data.frame should be integer indexes}
}
\value{
A character matrix with list elements as columns, padded with
empty strings to equal length.
}
\description{
Format a string list into a data.frame
}
\examples{
myList <- list("A"=LETTERS[3:5], "B"=LETTERS[4])
strList2DataFrame(myList)
strList2DataFrame(myList, colnames=c("FirstColumn", "SecondColumn"))
strList2DataFrame(myList, colnames=c("FirstColumn", "SecondColumn"), index=TRUE)

myFacList <- list("A"=gl(2,3, labels=LETTERS[1:2]), 
    "B"=gl(3,4, labels=LETTERS[1:3]))
strList2DataFrame(myFacList)
}
