% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.tableList.R
\name{write.tableList}
\alias{write.tableList}
\title{Write a list of data.frames (tables) into files}
\usage{
write.tableList(list, file.names, ...)
}
\arguments{
\item{list}{A list of data frames}

\item{file.names}{File names. If missing, the names of the list will be
used. Must be of the same length as the list}

\item{\dots}{Other parameters that are passed to \code{\link{write.table}}}
}
\value{
No return value, called for side effects (writes files).
}
\description{
Write a list of data.frames (tables) into files
}
\examples{
df1 <- data.frame(name=c("A", "B", "C"), value=1:3)
df2 <- data.frame(name=c("C", "D", "E"), value=seq(9,3,-3))
dflist <- list(file1=df1, file2=df2)
\donttest{
tmpdir <- tempdir()
write.tableList(dflist,
  file.names=file.path(tmpdir, c("file1.txt", "file2.txt")))
}

}
\seealso{
\code{\link{write.table}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
