% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeMatrix.tableList.R
\name{writeMatrix.tableList}
\alias{writeMatrix.tableList}
\title{Write a list of data.frames (tables) into file with writeMatrix}
\usage{
writeMatrix.tableList(list, file.names, row.names = TRUE, ...)
}
\arguments{
\item{list}{A list of data frames}

\item{file.names}{File names. If missing, the names of the list will be
used. Must be of the same length as the list}

\item{row.names}{Logical, whether row.names should be in the first, 
unnamed column of the output files}

\item{\dots}{Other parameters that are passed to \code{\link{writeMatrix}}}
}
\value{
Side-effects are used
}
\description{
Write a list of data.frames (tables) into file with writeMatrix
}
\examples{

td <- tempdir()
cwd <- getwd()
setwd(td)
df1 <- data.frame(name=c("A", "B", "C"), value=1:3)
df2 <- data.frame(name=c("C", "D", "E"), value=seq(9,3,-3))
dflist <- list(file1=df1, file2=df2)
writeMatrix.tableList(dflist) ## two files, file1 and file2, are written
dir()
writeMatrix.tableList(dflist, file.names=c("file1.txt", "file2.txt"))
dir()
setwd(cwd)

}
\seealso{
\code{\link{writeMatrix}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
