% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivs.R
\name{rxp_r}
\alias{rxp_r}
\title{Create a Nix Expression Running an R Function}
\usage{
rxp_r(
  name,
  expr,
  additional_files = "",
  user_functions = "",
  nix_env = "default.nix",
  encoder = NULL,
  decoder = NULL,
  env_var = NULL,
  noop_build = FALSE
)
}
\arguments{
\item{name}{Symbol, name of the derivation.}

\item{expr}{R code to generate the expression. Ideally it should be a call
to a pure function, or a piped expression. Multi-line expressions are not
supported.}

\item{additional_files}{Character vector, additional files to include
during the build process. For example, if a function expects a certain
file to be available, this is where you should include it.}

\item{user_functions}{Character vector, user-defined functions to include.
This should be a script (or scripts) containing user-defined functions
to include during the build process for this derivation. It is recommended
to use one script per function, and only include the required script(s) in
the derivation.}

\item{nix_env}{Character, path to the Nix environment file, default is
"default.nix".}

\item{encoder}{Function or character defaults to NULL. A function used to
encode (serialize) objects for transfer between derivations. It must accept two
arguments: the object to encode (first), and the target file path
(second). If your function has a different signature, wrap it to match this
interface. By default, \code{saveRDS()} is used, but this may yield unexpected
results, especially for complex objects like machine learning models. For
instance, for \code{{keras}} models, use \code{keras::save_model_hdf5()} to capture
the full model (architecture, weights, training config, optimiser state,
etc.). See \code{vignette("encoding-decoding")} for more details.}

\item{decoder}{Function, character, or named vector/list,
defaults to NULL. Can be:
\itemize{
\item A single function/string to decode (unserialize) all upstream objects (e.g., \code{readRDS})
\item A named vector/list where names are upstream dependency names and values
are their specific decoding functions (e.g.,
\code{c(mtcars_tail = "qs::qread", mtcars_head = "read.csv")})
By default, \code{readRDS()} is used. See \code{vignette("encoding-decoding")} for more details.
}}

\item{env_var}{Character vector, defaults to NULL. A named vector of
environment variables to set before running the R script, e.g.,
\verb{c("CMDSTAN" = "$\{defaultPkgs.cmdstan\}/opt/cmdstan)"}.
Each entry will be added as an export statement in the build phase.}

\item{noop_build}{Logical, defaults to FALSE. If TRUE, the derivation
produces a no-op build (a stub output with no actual build steps). Any
downstream derivations depending on a no-op build will themselves also
become no-op builds.}
}
\value{
An object of class derivation which inherits from lists.
}
\description{
Create a Nix Expression Running an R Function
}
\details{
At a basic level, \code{rxp_r(mtcars_am, filter(mtcars, am == 1))} is
equivalent to \code{mtcars_am <- filter(mtcars, am == 1)}. \code{rxp_r()} generates the
required Nix boilerplate to output a so-called "derivation" in Nix jargon.
A Nix derivation is a recipe that defines how to create an output (in this
case \code{mtcars_am}) including its dependencies, build steps, and output
paths.
}
\examples{
\dontrun{
  # Basic usage
  rxp_r(name = filtered_mtcars, expr = filter(mtcars, am == 1))

  # Skip building this derivation
  rxp_r(
    name = turtles,
    expr = occurrence(species, geometry = atlantic),
    noop_build = TRUE
  )

  # Serialize object using qs
  rxp_r(
   name = filtered_mtcars,
   expr = filter(mtcars, am == 1),
   encoder = qs::qsave
  )
  # Unerialize using qs::qread in the next derivation
  rxp_r(
   name = mtcars_mpg,
   expr = select(filtered_mtcars, mpg),
   decoder = qs::qread
  )
}
}
\seealso{
Other derivations: 
\code{\link{rxp_jl}()},
\code{\link{rxp_jl_file}()},
\code{\link{rxp_py}()},
\code{\link{rxp_py_file}()},
\code{\link{rxp_qmd}()},
\code{\link{rxp_r_file}()},
\code{\link{rxp_rmd}()}
}
\concept{derivations}
