/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDate;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.HolidaysCorrectedTradingDays;
import jdplus.toolkit.base.core.math.matrices.MatrixFactory;
import lombok.Generated;

class ChainedCalendarCorrector
implements HolidaysCorrectedTradingDays.HolidaysCorrector {
    final HolidaysCorrectedTradingDays.HolidaysCorrector beg;
    final HolidaysCorrectedTradingDays.HolidaysCorrector end;
    final LocalDate breakDate;

    public Matrix rawCorrection(TsDomain domain) {
        int n = domain.getLength();
        int pos = domain.indexOf(this.breakDate.atStartOfDay());
        if (pos > 0) {
            Matrix M1 = this.beg.rawCorrection(domain.range(0, pos));
            Matrix M2 = this.end.rawCorrection(domain.range(pos, n));
            return MatrixFactory.rowBind(M1, M2);
        }
        if (pos >= -1) {
            return this.end.rawCorrection(domain);
        }
        return this.beg.rawCorrection(domain);
    }

    public Matrix holidaysCorrection(TsDomain domain) {
        int n = domain.getLength();
        int pos = domain.indexOf(this.breakDate.atStartOfDay());
        if (pos > 0) {
            Matrix M1 = this.beg.holidaysCorrection(domain.range(0, pos));
            Matrix M2 = this.end.holidaysCorrection(domain.range(pos, n));
            return MatrixFactory.rowBind(M1, M2);
        }
        if (pos >= -1) {
            return this.end.holidaysCorrection(domain);
        }
        return this.beg.holidaysCorrection(domain);
    }

    public DoubleSeq longTermYearlyCorrection() {
        return this.end.longTermYearlyCorrection();
    }

    @Generated
    public ChainedCalendarCorrector(HolidaysCorrectedTradingDays.HolidaysCorrector beg, HolidaysCorrectedTradingDays.HolidaysCorrector end, LocalDate breakDate) {
        this.beg = beg;
        this.end = end;
        this.breakDate = breakDate;
    }
}

