/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

public class DefaultLikelihoodEvaluation {
    public static ToDoubleFunction<Likelihood> ml() {
        return likelihood -> -likelihood.logLikelihood();
    }

    public static ToDoubleFunction<Likelihood> deviance() {
        return likelihood -> likelihood.ssq() * likelihood.factor();
    }

    public static ToDoubleFunction<Likelihood> ssq() {
        return likelihood -> likelihood.ssq();
    }

    public static ToDoubleFunction<Likelihood> logSsq() {
        return likelihood -> Math.log(likelihood.ssq());
    }

    public static Function<Likelihood, DoubleSeq> errors() {
        return likelihood -> likelihood.e();
    }

    public static Function<Likelihood, DoubleSeq> v() {
        return likelihood -> likelihood.deviances();
    }
}

