/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.modelling.highfreq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.modelling.highfreq.EasterSpec;
import jdplus.toolkit.base.api.modelling.highfreq.HolidaysSpec;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.TsContextVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class RegressionSpec {
    @NonNull
    private final HolidaysSpec holidays;
    @NonNull
    private final EasterSpec easter;
    private final List<Variable<IOutlier>> outliers;
    private final List<Variable<InterventionVariable>> interventionVariables;
    private final List<Variable<TsContextVariable>> userDefinedVariables;
    public static final RegressionSpec DEFAULT = RegressionSpec.builder().build();

    public static Builder builder() {
        return new Builder().holidays(HolidaysSpec.DEFAULT_UNUSED).easter(EasterSpec.DEFAULT_UNUSED);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    public boolean isUsed() {
        return this.holidays.isUsed() || this.easter.isUsed() || !this.outliers.isEmpty() || !this.interventionVariables.isEmpty() || !this.userDefinedVariables.isEmpty();
    }

    public boolean hasFixedCoefficients() {
        if (!this.isUsed()) {
            return false;
        }
        return this.holidays.hasFixedCoefficients() || this.outliers.stream().anyMatch(var -> !var.isFree()) || this.interventionVariables.stream().anyMatch(var -> !var.isFree()) || this.userDefinedVariables.stream().anyMatch(var -> !var.isFree());
    }

    @Generated
    RegressionSpec(@NonNull HolidaysSpec holidays, @NonNull EasterSpec easter, List<Variable<IOutlier>> outliers, List<Variable<InterventionVariable>> interventionVariables, List<Variable<TsContextVariable>> userDefinedVariables) {
        if (holidays == null) {
            throw new NullPointerException("holidays is marked non-null but is null");
        }
        if (easter == null) {
            throw new NullPointerException("easter is marked non-null but is null");
        }
        this.holidays = holidays;
        this.easter = easter;
        this.outliers = outliers;
        this.interventionVariables = interventionVariables;
        this.userDefinedVariables = userDefinedVariables;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().holidays(this.holidays).easter(this.easter);
        if (this.outliers != null) {
            builder.outliers(this.outliers);
        }
        if (this.interventionVariables != null) {
            builder.interventionVariables(this.interventionVariables);
        }
        if (this.userDefinedVariables != null) {
            builder.userDefinedVariables(this.userDefinedVariables);
        }
        return builder;
    }

    @NonNull
    @Generated
    public HolidaysSpec getHolidays() {
        return this.holidays;
    }

    @NonNull
    @Generated
    public EasterSpec getEaster() {
        return this.easter;
    }

    @Generated
    public List<Variable<IOutlier>> getOutliers() {
        return this.outliers;
    }

    @Generated
    public List<Variable<InterventionVariable>> getInterventionVariables() {
        return this.interventionVariables;
    }

    @Generated
    public List<Variable<TsContextVariable>> getUserDefinedVariables() {
        return this.userDefinedVariables;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegressionSpec)) {
            return false;
        }
        RegressionSpec other = (RegressionSpec)o;
        HolidaysSpec this$holidays = this.getHolidays();
        HolidaysSpec other$holidays = other.getHolidays();
        if (this$holidays == null ? other$holidays != null : !((Object)this$holidays).equals(other$holidays)) {
            return false;
        }
        EasterSpec this$easter = this.getEaster();
        EasterSpec other$easter = other.getEaster();
        if (this$easter == null ? other$easter != null : !((Object)this$easter).equals(other$easter)) {
            return false;
        }
        List<Variable<IOutlier>> this$outliers = this.getOutliers();
        List<Variable<IOutlier>> other$outliers = other.getOutliers();
        if (this$outliers == null ? other$outliers != null : !((Object)this$outliers).equals(other$outliers)) {
            return false;
        }
        List<Variable<InterventionVariable>> this$interventionVariables = this.getInterventionVariables();
        List<Variable<InterventionVariable>> other$interventionVariables = other.getInterventionVariables();
        if (this$interventionVariables == null ? other$interventionVariables != null : !((Object)this$interventionVariables).equals(other$interventionVariables)) {
            return false;
        }
        List<Variable<TsContextVariable>> this$userDefinedVariables = this.getUserDefinedVariables();
        List<Variable<TsContextVariable>> other$userDefinedVariables = other.getUserDefinedVariables();
        return !(this$userDefinedVariables == null ? other$userDefinedVariables != null : !((Object)this$userDefinedVariables).equals(other$userDefinedVariables));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HolidaysSpec $holidays = this.getHolidays();
        result = result * 59 + ($holidays == null ? 43 : ((Object)$holidays).hashCode());
        EasterSpec $easter = this.getEaster();
        result = result * 59 + ($easter == null ? 43 : ((Object)$easter).hashCode());
        List<Variable<IOutlier>> $outliers = this.getOutliers();
        result = result * 59 + ($outliers == null ? 43 : ((Object)$outliers).hashCode());
        List<Variable<InterventionVariable>> $interventionVariables = this.getInterventionVariables();
        result = result * 59 + ($interventionVariables == null ? 43 : ((Object)$interventionVariables).hashCode());
        List<Variable<TsContextVariable>> $userDefinedVariables = this.getUserDefinedVariables();
        result = result * 59 + ($userDefinedVariables == null ? 43 : ((Object)$userDefinedVariables).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "RegressionSpec(holidays=" + String.valueOf(this.getHolidays()) + ", easter=" + String.valueOf(this.getEaster()) + ", outliers=" + String.valueOf(this.getOutliers()) + ", interventionVariables=" + String.valueOf(this.getInterventionVariables()) + ", userDefinedVariables=" + String.valueOf(this.getUserDefinedVariables()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private HolidaysSpec holidays;
        @Generated
        private EasterSpec easter;
        @Generated
        private ArrayList<Variable<IOutlier>> outliers;
        @Generated
        private ArrayList<Variable<InterventionVariable>> interventionVariables;
        @Generated
        private ArrayList<Variable<TsContextVariable>> userDefinedVariables;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder holidays(@NonNull HolidaysSpec holidays) {
            if (holidays == null) {
                throw new NullPointerException("holidays is marked non-null but is null");
            }
            this.holidays = holidays;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder easter(@NonNull EasterSpec easter) {
            if (easter == null) {
                throw new NullPointerException("easter is marked non-null but is null");
            }
            this.easter = easter;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder outlier(Variable<IOutlier> outlier) {
            if (this.outliers == null) {
                this.outliers = new ArrayList();
            }
            this.outliers.add(outlier);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder outliers(@org.jspecify.annotations.NonNull Collection<? extends Variable<IOutlier>> outliers) {
            if (outliers == null) {
                throw new NullPointerException("outliers cannot be null");
            }
            if (this.outliers == null) {
                this.outliers = new ArrayList();
            }
            this.outliers.addAll(outliers);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearOutliers() {
            if (this.outliers != null) {
                this.outliers.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder interventionVariable(Variable<InterventionVariable> interventionVariable) {
            if (this.interventionVariables == null) {
                this.interventionVariables = new ArrayList();
            }
            this.interventionVariables.add(interventionVariable);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder interventionVariables(@org.jspecify.annotations.NonNull Collection<? extends Variable<InterventionVariable>> interventionVariables) {
            if (interventionVariables == null) {
                throw new NullPointerException("interventionVariables cannot be null");
            }
            if (this.interventionVariables == null) {
                this.interventionVariables = new ArrayList();
            }
            this.interventionVariables.addAll(interventionVariables);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearInterventionVariables() {
            if (this.interventionVariables != null) {
                this.interventionVariables.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder userDefinedVariable(Variable<TsContextVariable> userDefinedVariable) {
            if (this.userDefinedVariables == null) {
                this.userDefinedVariables = new ArrayList();
            }
            this.userDefinedVariables.add(userDefinedVariable);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder userDefinedVariables(@org.jspecify.annotations.NonNull Collection<? extends Variable<TsContextVariable>> userDefinedVariables) {
            if (userDefinedVariables == null) {
                throw new NullPointerException("userDefinedVariables cannot be null");
            }
            if (this.userDefinedVariables == null) {
                this.userDefinedVariables = new ArrayList();
            }
            this.userDefinedVariables.addAll(userDefinedVariables);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearUserDefinedVariables() {
            if (this.userDefinedVariables != null) {
                this.userDefinedVariables.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull RegressionSpec build() {
            return new RegressionSpec(this.holidays, this.easter, switch (this.outliers == null ? 0 : this.outliers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.outliers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable<IOutlier>>(this.outliers));
            }, switch (this.interventionVariables == null ? 0 : this.interventionVariables.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.interventionVariables.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable<InterventionVariable>>(this.interventionVariables));
            }, switch (this.userDefinedVariables == null ? 0 : this.userDefinedVariables.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.userDefinedVariables.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable<TsContextVariable>>(this.userDefinedVariables));
            });
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "RegressionSpec.Builder(holidays=" + String.valueOf(this.holidays) + ", easter=" + String.valueOf(this.easter) + ", outliers=" + String.valueOf(this.outliers) + ", interventionVariables=" + String.valueOf(this.interventionVariables) + ", userDefinedVariables=" + String.valueOf(this.userDefinedVariables) + ")";
        }
    }
}

