% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_paleofauna.R
\name{road_get_paleofauna}
\alias{road_get_paleofauna}
\title{Get paleofauna data from the ROAD database}
\usage{
road_get_paleofauna(
  continent = NULL,
  subcontinent = NULL,
  country = NULL,
  locality_type = NULL,
  cultural_period = NULL,
  technocomplex = NULL,
  category = NULL,
  age_min = NULL,
  age_max = NULL,
  assemblages = NULL,
  fauna_genus = NULL,
  fauna_species = NULL
)
}
\arguments{
\item{continent}{specifies the continent(s) (e.g. Africa, Europe, Asia).
Run \code{road_list_argument_values("continent")} to display possible values.
The argument \code{continent} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{subcontinent}{specifies the continental region(s) (e.g. Southern Europe).
Run \code{road_list_argument_values("subcontinent")} to display possible values.
The argument \code{subcontinent} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{country}{specifies the name of the country where a locality is situated
(e.g. Germany, Kenya, Saudi Arabia). Run \code{road_list_argument_values("country")}
to display possible values.
The argument \code{country} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{locality_type}{specifies the type of locality (e.g. cave, rockshelter, open air).
Run \code{road_list_argument_values("locality_type")} to display possible values.
The argument \code{locality_type} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{cultural_period}{specifies the main cultural epoch(s) and includes the
Eurasian Paleolithic (Lower, Middle, Upper, Epi-) and the African Stone Age
(Earlier, Middle, Later). Run \code{road_list_argument_values("cultural_period")}
to display possible values. The argument \code{cultural_period} is a string
(one item) or vector of strings (one or more items); defaults to NULL.}

\item{technocomplex}{specifies an archaeological culture or named stone tool
industry (e.g. Oldowan, Acheulean, Mousterian).
Run \code{road_list_argument_values("technocomplex")} to display possible values.
The argument \code{technocomplex} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{category}{specifies the assemblage category with the classes
human remains, raw material, typology, technology, function, organic tools,
symbolic artifacts, feature, miscellaneous finds, paleofauna, animal remains,
plant remains. The argument \code{category} is a string (one item) or
vector of strings (one or more items); defaults to NULL.}

\item{age_min}{specifies the minimum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_min} will be converted to an integer; defaults to NULL.}

\item{age_max}{specifies the maximum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_max} will be converted to an integer; defaults to NULL.}

\item{assemblages}{specifies a data frame necessarily containing columns 
locality_id, assemblage_id. It can be  generated as return value of the 
function 'road_get_assemblages'. It can be used instead of the locality 
and assemblage search parameters to filter the results.}

\item{fauna_genus}{specifies the genus to which the described faunal remains
is attributed to. Possible entries include: "Mammuthus", "Vulpes" etc.
Run \code{road_list_argument_values("fauna_genus")} to
display possible values. The argument \code{fauna_genus} is a string
(one item) or vector of strings; defaults to NULL.}

\item{fauna_species}{specifies the species to which the
described faunal remains is attributed. Possible entries include:
"primigenius", "vulpes" or "sp." for unidentified species. Run
\code{road_list_argument_values("fauna_species")} to display possible values.
The argument \code{fauna_species} is a string (one item) or vector of strings;
defaults to NULL.}
}
\value{
A data frame with paleofauna information. Rows represent individual
faunal remains finds, columns contain standard outputs and faunal remains-related details on:

\code{fauna_genus}, \code{fauna_species}: The attributes specify the taxonomic classification of the paleofaunal remains.
}
\description{
The \strong{\code{road_get_paleofauna}} function retrieves data on paleofauna finds from the ROAD database.
Paleofauna finds are animal fossil remains discovered in archaeological contexts and are always associated with an assemblage.
These finds provide direct evidence for the presence of animal species at a particular locality and time.
The function returns information about the assemblage in which certain faunal remains were found as well as their genus and species.
}
\details{
Use the parameters to filter the results or omit them to retrieve a broader dataset.
Genus and species parameters can be entered as a vector of strings to search for multiple entries.
If genus and species are both specified, most of the time it's more sensible to enter them as
single strings and not as vectors with multiple search words to recieve useful results.
}
\examples{
\donttest{road_get_paleofauna(country = c("Spain", "Portugal"), fauna_genus = "Mammuthus")}
\donttest{road_get_paleofauna(continent = "Africa", fauna_genus = "Vulpes",
                    fauna_species = "vulpes")}
}
