\name{efficiency}
\alias{efficiency}
\title{Function for Estimating Technical Efficiencies for Class \code{rsfa}}
\usage{
efficiency(object, ...)
}
\arguments{
  \item{object}{An object of class \code{rsfa}.}

  \item{...}{Unsed.}
}
\value{
  A column vector of the estimated individual efficiencies.
}
\description{
  This function returns the individual efficiencies calculated from the
  MDPD or ML estimates.  The efficiencies are calculated 
  using the estimator of Battese and Coelli (1988).
}
\examples{
## Example using the 'riceProdPhil' dataset from the `frontier` package
library(frontier)
data(riceProdPhil)

my.model <- log(PROD) ~ log(AREA) + log(LABOR) + log(NPK) + log(OTHER)
fit.ml <- rsfa(my.model, data = riceProdPhil)
efficiency(fit.ml)
fit.mdpde<- rsfa(my.model, data = riceProdPhil, alpha = 0.1)
efficiency(fit.mdpde)
}
\references{
  Battese, G.E. and Coelli, T. (1988). Prediction of firm-level technical efficiencies 
  with a generalized frontier production function and panel
  data. Journal of Econometrics, 38, 387-399.
}
