% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_accessors.R
\name{colcount_visible}
\alias{colcount_visible}
\alias{colcount_visible,VTableTree-method}
\alias{colcount_visible,InstantiatedColumnInfo-method}
\alias{colcount_visible,LayoutColTree-method}
\alias{colcount_visible<-}
\alias{colcount_visible<-,VTableTree-method}
\alias{colcount_visible<-,InstantiatedColumnInfo-method}
\alias{colcount_visible<-,LayoutColTree-method}
\title{Value and Visibility of specific column counts by path}
\usage{
colcount_visible(obj, path)

\S4method{colcount_visible}{VTableTree}(obj, path)

\S4method{colcount_visible}{InstantiatedColumnInfo}(obj, path)

\S4method{colcount_visible}{LayoutColTree}(obj, path)

colcount_visible(obj, path) <- value

\S4method{colcount_visible}{VTableTree}(obj, path) <- value

\S4method{colcount_visible}{InstantiatedColumnInfo}(obj, path) <- value

\S4method{colcount_visible}{LayoutColTree}(obj, path) <- value
}
\arguments{
\item{obj}{(\code{ANY})\cr the object for the accessor to access or modify.}

\item{path}{(\code{character})\cr a vector path for a position within the structure of a \code{TableTree}. Each element
represents a subsequent choice amongst the children of the previous choice.}

\item{value}{(\code{ANY})\cr the new value.}
}
\value{
for \code{colcount_visible} a logical scalar
indicating whether the specified position in
the column hierarchy is set to display its column count;
for \verb{colcount_visible<-}, \code{obj} updated with
the specified count displaying behavior set.
}
\description{
Value and Visibility of specific column counts by path
}
\note{
Users generally should not call \code{colcount_visible}
directly, as setting sibling facets to have differing
column count visibility will result in an error when
printing or paginating the table.
}
