% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sValues.R
\name{coef.sValues}
\alias{coef.sValues}
\alias{betas}
\alias{t_values}
\alias{s_values}
\alias{extreme_bounds}
\title{Extract sValues Model Coefficients/Statistics}
\usage{
\method{coef}{sValues}(object, type = "default", ...)

betas(object)

t_values(object)

s_values(object)

extreme_bounds(object)
}
\arguments{
\item{object}{an object of class \code{\link{sValues}}.}

\item{type}{which coefficient/statistic to extract? Current options are "betas", "t_values", 
"s_values", "extreme_bounds" and "default". See details.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The function returns a \code{data.frame} with the estimates for each variable.
}
\description{
Extract sValues Model Coefficients/Statistics
}
\details{
For the \code{coef} function, the default is to extract the beta coefficients, t-values and s-values. You can can get 
each one of those individually by setting \code{type} to either "betas", "t_values" or "s_values". 
You can also get the extreme bounds of the estimates by setting \code{type} to "extreme_bounds". 
Finally, you can set \code{type = "all"} to get everything. 

For each option of \code{coef}, there is an alternative helper function with the same name. 
That is, \code{coef(x, "betas")} is equivalent to \code{betas(x)}, or \code{coef(x, "extreme_bounds")} is equivalent
to \code{extreme_bounds(x)}.
}
\examples{
data(economic_growth)
eg_sv <- sValues(GR6096 ~ ., data = economic_growth)
eg_betas <- coef(eg_sv, "betas")
eg_t_values <- coef(eg_sv, "t_values")
eg_s_values <- coef(eg_sv, "s_values")
eg_ext_bounds <- coef(eg_sv, "extreme_bounds")

# get sturdy estimates for R2 bounds 0.5 - 1
eg_s_values[abs(eg_s_values[3]) > 1, 3, drop = FALSE]


}
\seealso{
\code{\link{summary.sValues}}.
}
