% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Output_Tables.R
\name{uni_compare_table}
\alias{uni_compare_table}
\title{Create an Output-Table of a uni_compare_object}
\usage{
uni_compare_table(
  uni_compare_object,
  conf_adjustment = FALSE,
  df_names = NULL,
  varlabels = NULL,
  ci_line = TRUE,
  ndigits = 3
)
}
\arguments{
\item{uni_compare_object}{A object returned by
\code{\link[sampcompR]{uni_compare}}.}

\item{conf_adjustment}{A logical parameter determining if adjusted
confidence intervals should be returned.}

\item{df_names}{A character vector to relabel the data frames of comparison.}

\item{varlabels}{A character vector to relabel the variables in the table.}

\item{ci_line}{If \code{TRUE}, confidence intervals will be displayed in a
separate line, otherwise, they are shown in the same line instead.}

\item{ndigits}{The number of digits to round the numbers in table.}
}
\value{
A table containing information on the univariate comparison based on
the \code{\link[sampcompR]{uni_compare}} function.
}
\description{
Returns a table based on the information of an \code{uni_compare_object}
which can be outputted as HTML or LaTex Table, for example with the help of
the \link[stargazer]{stargazer} function.
}
\examples{

## Get Data for comparison

data("card")

north <- card[card$south==0,]
white <- card[card$black==0,]

## use the function to plot the data 
univar_data<-sampcompR::uni_compare(dfs = c("north","white"),
                                    benchmarks = c("card","card"),
                                    variables= c("age","educ","fatheduc","motheduc","wage","IQ"),
                                    funct = "abs_rel_mean",
                                    nboots=0,
                                    summetric="rmse2",
                                    data=TRUE)

table<-sampcompR::uni_compare_table(univar_data)
noquote(table)

}
