% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_scholid.R
\name{is_scholid}
\alias{is_scholid}
\title{Test scholarly identifier validity}
\usage{
is_scholid(x, type)
}
\arguments{
\item{x}{A vector of values to test.}

\item{type}{A single string giving the identifier type. See
\code{\link[=scholid_types]{scholid_types()}} for supported values.}
}
\value{
A logical vector of the same length as \code{x}, indicating whether
each element is a valid identifier of the specified type.
}
\description{
Vectorized predicate that tests whether values are valid scholarly
identifiers of a given supported type.

Validation is stricter than normalization. Values must conform to the
canonical identifier syntax, and for identifier types with checksum
algorithms (e.g., ORCID, ISBN, ISSN), checksum correctness is verified.

Inputs that are \code{NA} yield \code{NA}. Non-matching values return \code{FALSE}.

Use \code{\link[=normalize_scholid]{normalize_scholid()}} to convert structurally plausible identifiers
to canonical form without performing checksum validation.
}
\examples{
is_scholid("10.1000/182", "doi")
is_scholid("0000-0002-1825-0097", "orcid")

}
\seealso{
\code{\link[=normalize_scholid]{normalize_scholid()}}, \code{\link[=scholid_types]{scholid_types()}}
}
