% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tape_Jacobian}
\alias{tape_Jacobian}
\title{Tape the Jacobian of CppAD Tape}
\usage{
tape_Jacobian(pfun)
}
\arguments{
\item{pfun}{An \code{Rcpp_ADFun} object.}
}
\value{
An \code{Rcpp_ADFun} object.
}
\description{
Creates a tape of the Jacobian of a function taped by \code{CppAD}.
When the function returns a real value (as is the case for densities and the score matching objective) the Jacobian is equivalent to the gradient.
The \code{x} vector is used as the value to conduct the taping.
}
\details{
When the returned tape is evaluated (via say \verb{$eval()}, the resultant vector contains the Jacobian in long format (see \url{https://cppad.readthedocs.io/latest/Jacobian.html}).
Suppose the function represented by \code{pfun} maps from \eqn{n}-dimensional space to \eqn{m}-dimensional space, then
the first \eqn{n} elements of vector is the gradient of the first component of function output.
The next \eqn{n} elements of the vector is the gradient of the second component of the function output.
The Jacobian as a matrix, could then be obtained by \code{\link[=as.matrix]{as.matrix()}} with \code{byrow = TRUE} and \code{ncol = n}.

For creating this tape, the values of \code{pfun$xtape} and \code{pfun$dyntape} are used.
}
\seealso{
Other tape builders: 
\code{\link{avgrange}()},
\code{\link{fixdynamic}()},
\code{\link{fixindependent}()},
\code{\link{keeprange}()},
\code{\link{tape_Hessian}()},
\code{\link{tape_bdryw}()},
\code{\link{tape_gradoffset}()},
\code{\link{tape_logJacdet}()},
\code{\link{tape_smd}()},
\code{\link{tape_swap}()},
\code{\link{tape_uld}()}
}
\concept{tape builders}
