% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.seroincidence.by.R
\name{print.seroincidence.by}
\alias{print.seroincidence.by}
\title{Print Method for \code{seroincidence.by} Object}
\usage{
\method{print}{seroincidence.by}(x, ...)
}
\arguments{
\item{x}{A list containing output of function \code{\link[=est_seroincidence_by]{est_seroincidence_by()}}.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
an \link{invisible} copy of input parameter \code{x}
}
\description{
Custom \code{\link[=print]{print()}} function for \code{seroincidence.by} objects
(from \code{\link[=est_seroincidence_by]{est_seroincidence_by()}})
}
\examples{
library(dplyr)

xs_data <-
  sees_pop_data_pk_100

curve <-
  typhoid_curves_nostrat_100 |>
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

noise <-
  example_noise_params_pk

# estimate seroincidence
est2 <- est_seroincidence_by(
  strata = c("catchment"),
  pop_data = xs_data,
  sr_params = curve,
  noise_params = noise,
  antigen_isos = c("HlyE_IgG", "HlyE_IgA"),
  # num_cores = 8 # Allow for parallel processing to decrease run time
)

# calculate summary statistics for the seroincidence object
print(est2)

}
\keyword{internal}
