# stratify_data() produces consistent results

    Code
      stratified_data
    Output
      $`Stratum 1`
      $pop_data
      # A tibble: 106 x 3
          value   age antigen_iso
          <dbl> <dbl> <fct>      
       1 5.69    18   HlyE_IgA   
       2 1.23     7.3 HlyE_IgA   
       3 1.08     2.6 HlyE_IgA   
       4 1.43     3.9 HlyE_IgA   
       5 3.06    13   HlyE_IgA   
       6 3.10    14.4 HlyE_IgA   
       7 0.0308   3.4 HlyE_IgA   
       8 6.39    22   HlyE_IgA   
       9 0.240    4   HlyE_IgA   
      10 3.45    14.8 HlyE_IgA   
      # i 96 more rows
      
      $antigen_isos
      [1] "HlyE_IgA" "HlyE_IgG"
      
      $sr_params
      # A tibble: 200 x 4
            y1    alpha     r antigen_iso
         <dbl>    <dbl> <dbl> <fct>      
       1  63.5 0.000581  1.75 HlyE_IgA   
       2 164.  0.00457   1.17 HlyE_IgG   
       3 288.  0.000459  2.66 HlyE_IgA   
       4 154.  0.000921  1.30 HlyE_IgG   
       5 432.  0.000277  1.61 HlyE_IgA   
       6 143.  0.00294   1.13 HlyE_IgG   
       7  30.6 0.00127   1.87 HlyE_IgA   
       8  53.3 0.000185  2.13 HlyE_IgG   
       9 160.  0.00140   1.40 HlyE_IgA   
      10 557.  0.000505  1.97 HlyE_IgG   
      # i 190 more rows
      
      $noise_params
      # A tibble: 2 x 5
           nu   eps y.low  y.high antigen_iso
        <dbl> <dbl> <dbl>   <dbl> <chr>      
      1  2.60 0.279 0.508 5000000 HlyE_IgA   
      2  2.36 0.146 1.59  5000000 HlyE_IgG   
      
      attr(,"class")
      [1] "biomarker_data_and_params" "list"                     
      
      $`Stratum 2`
      $pop_data
      # A tibble: 94 x 3
         value   age antigen_iso
         <dbl> <dbl> <fct>      
       1 0.568  13.2 HlyE_IgA   
       2 0.779  11   HlyE_IgA   
       3 1.90   12   HlyE_IgA   
       4 1.41   16   HlyE_IgA   
       5 7.12    7.6 HlyE_IgA   
       6 0       2.3 HlyE_IgA   
       7 2.90    4   HlyE_IgA   
       8 1.44    5.1 HlyE_IgA   
       9 3.77   18.7 HlyE_IgA   
      10 2.80    7   HlyE_IgA   
      # i 84 more rows
      
      $antigen_isos
      [1] "HlyE_IgA" "HlyE_IgG"
      
      $sr_params
      # A tibble: 200 x 4
            y1    alpha     r antigen_iso
         <dbl>    <dbl> <dbl> <fct>      
       1  63.5 0.000581  1.75 HlyE_IgA   
       2 164.  0.00457   1.17 HlyE_IgG   
       3 288.  0.000459  2.66 HlyE_IgA   
       4 154.  0.000921  1.30 HlyE_IgG   
       5 432.  0.000277  1.61 HlyE_IgA   
       6 143.  0.00294   1.13 HlyE_IgG   
       7  30.6 0.00127   1.87 HlyE_IgA   
       8  53.3 0.000185  2.13 HlyE_IgG   
       9 160.  0.00140   1.40 HlyE_IgA   
      10 557.  0.000505  1.97 HlyE_IgG   
      # i 190 more rows
      
      $noise_params
      # A tibble: 2 x 5
           nu   eps y.low  y.high antigen_iso
        <dbl> <dbl> <dbl>   <dbl> <chr>      
      1  2.60 0.279 0.508 5000000 HlyE_IgA   
      2  2.36 0.146 1.59  5000000 HlyE_IgG   
      
      attr(,"class")
      [1] "biomarker_data_and_params" "list"                     
      
      attr(,"antigen_isos")
      [1] "HlyE_IgA" "HlyE_IgG"
      attr(,"strata")
      # A tibble: 2 x 3
        Stratum   catchment     n
        <chr>     <chr>     <int>
      1 Stratum 1 aku          53
      2 Stratum 2 kgh          47
      attr(,"class")
      [1] "biomarker_data_and_params.list" "list"                          

---

    WAoAAAACAAQEAQACAwAAAAMTAAAAAgAAAxMAAAAEAAADEwAAAAMAAAAOAAAAakAWvoxNeCVN
    P/Onzt9DE3I/8VtI8+S+sT/23jYNHAwUQAh+0r2wLOJACNPJBUIJOj+fhZSyh6/AQBmP8T/I
    wtI/zsXBZnhrMkALod8ymcoFP+KogdrHR44/8z+omnENkkAs5sBmNxaYQCtZWgVaBwhAI4J7
    8mm/YT/9rGg0+z0AQCr0M02KTHVAD1JSj3eKWT/inhv4C8hpP93CDJtVFsQ/6cCkYynOjj/F
    2cHIC/LSP/Xvp83kz85ACO+jFhGGsz/kNHt4JAajP91AMjXDbI1AA2cUtI9gqD/7TI4NFd+I
    QA0aR0DtbDtAUXlNkEvoC0ACy0l/et9vQANgOBSZah9AF9Yc+tFbwj/zVozOHfR2QDWrN65C
    HTE//7D1Mq24cUAbyn5SSQCuP9Te2IHQk/A/+/MXghaJ9EAW+akENIbfQFCXmtTixd1AIS9s
    ODd+8kAjHnyycfF5P/dpT6AD9Io/+s/Eo1T7p0AAA6yaypOEP/9phywdhA4/wm6fSUq7f0AF
    ILh/fKazQAUeUbiVmWtALfF22fwKUj/inc70iRgxP/mP8tbd2PVAENhrLVMn+UAIA/vlNZu7
    P8vDraEv3WA/7psiGuWSHkAjJLsgL6juP/WsR0m3/FM/8FEgxtssckBAzp556KREP83+MGl2
    s4g//4SyNlm/dT//m3932lckP9efLkfVxl9ADoHeoLTA50AaQh51HEfwQBwtMWowSnZAA1vP
    83tq40AWdLSMBamwP+WsrG67/fs/25TxFXjafz/vdHDCV0phP9Y3+xkQcj4/5bnMxcmA8T/1
    +MIFJjgsP/W7A9J7FSg/+bmd2ZGjoz/lLJu8tHvIQA3a9QpYnn1AADrGXXqNGEAIrJvjfnKq
    QDBttttz2ZdAEGZ5NhCh/kAz+HxpXRDSQCCXnnnkWMFALBapBchA90Ab1bbba0KRQAwvPPPI
    sYJAI6OeeeRYwT/QLbE1jvp8P+wE7jgbPjk/8W0DzuyMsUAZPPPPRSIeQBce0m2PaVlAFTt+
    RH6KHz/xV66v53UAP+nVcj7QjxNAKqg/FWmeqj/hENE47TFxP/ZvOprByPRAG8pxewZKYUAS
    HDDDDdOgP/+JGWA9G1hAE3xqQ7gIEUAA/aDaGYBIAAAADgAAAGpAMgAAAAAAAEAdMzMzMzMz
    QATMzMzMzM1ADzMzMzMzM0AqAAAAAAAAQCzMzMzMzM1ACzMzMzMzM0A2AAAAAAAAQBAAAAAA
    AABALZmZmZmZmkAuMzMzMzMzQCoAAAAAAABALzMzMzMzM0AyAAAAAAAAQDKzMzMzMzNAHgAA
    AAAAAEA3AAAAAAAAQBAAAAAAAABAAmZmZmZmZkAjmZmZmZmaQDUAAAAAAABALWZmZmZmZkAQ
    AAAAAAAAQDIZmZmZmZpAJmZmZmZmZkAOZmZmZmZmQCcAAAAAAABAMTMzMzMzM0AxAAAAAAAA
    QCgAAAAAAABAJgAAAAAAAEAwAAAAAAAAQBQAAAAAAABAKAAAAAAAAEA0AAAAAAAAQCwAAAAA
    AABAHTMzMzMzM0AEAAAAAAAAQCUAAAAAAABAEZmZmZmZmkAmZmZmZmZmQCrMzMzMzM1ALAAA
    AAAAAEAtMzMzMzMzQDMzMzMzMzNAJAAAAAAAAEAUAAAAAAAAQBOZmZmZmZpAImZmZmZmZkAv
    mZmZmZmaQDIAAAAAAABANQAAAAAAAEAaZmZmZmZmQDIAAAAAAABAHTMzMzMzM0AEzMzMzMzN
    QA8zMzMzMzNAKgAAAAAAAEAszMzMzMzNQAszMzMzMzNANgAAAAAAAEAQAAAAAAAAQC2ZmZmZ
    mZpALjMzMzMzM0AqAAAAAAAAQC8zMzMzMzNAMgAAAAAAAEAyszMzMzMzQB4AAAAAAABANwAA
    AAAAAEAQAAAAAAAAQAJmZmZmZmZAI5mZmZmZmkA1AAAAAAAAQC1mZmZmZmZAEAAAAAAAAEAy
    GZmZmZmaQCZmZmZmZmZADmZmZmZmZkAnAAAAAAAAQDEzMzMzMzNAMQAAAAAAAEAoAAAAAAAA
    QCYAAAAAAABAMAAAAAAAAEAUAAAAAAAAQCgAAAAAAABANAAAAAAAAEAsAAAAAAAAQB0zMzMz
    MzNABAAAAAAAAEAlAAAAAAAAQBGZmZmZmZpAJmZmZmZmZkAqzMzMzMzNQCwAAAAAAABALTMz
    MzMzM0AzMzMzMzMzQCQAAAAAAABAFAAAAAAAAEATmZmZmZmaQCJmZmZmZmZAL5mZmZmZmkAy
    AAAAAAAAQDUAAAAAAABAGmZmZmZmZgAAAw0AAABqAAAAAQAAAAEAAAABAAAAAQAAAAEAAAAB
    AAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAA
    AAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAAB
    AAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAA
    AAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAAC
    AAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAA
    AAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAAC
    AAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAA
    AAIAAAACAAAAAgAAAAIAAAACAAAAAgAABAIAAAABAAQACQAAAAZsZXZlbHMAAAAQAAAAAgAE
    AAkAAAAISGx5RV9JZ0EABAAJAAAACEhseUVfSWdHAAAEAgAAAAEABAAJAAAABWNsYXNzAAAA
    EAAAAAEABAAJAAAABmZhY3RvcgAAAP4AAAQCAAAAAQAEAAkAAAAFbmFtZXMAAAAQAAAAAwAE
    AAkAAAAFdmFsdWUABAAJAAAAA2FnZQAEAAkAAAALYW50aWdlbl9pc28AAAQCAAAAAQAEAAkA
    AAAJcm93Lm5hbWVzAAAADQAAAAKAAAAA////lgAABAIAAAL/AAAAEAAAAAQABAAJAAAACHBv
    cF9kYXRhAAQACQAAAAZ0YmxfZGYABAAJAAAAA3RibAAEAAkAAAAKZGF0YS5mcmFtZQAABAIA
    AAABAAQACQAAAAxhbnRpZ2VuX2lzb3MAAAAQAAAAAgAEAAkAAAAISGx5RV9JZ0EABAAJAAAA
    CEhseUVfSWdHAAAEAgAAAAEABAAJAAAAB2FnZV92YXIAAAAQAAAAAQAEAAkAAAADYWdlAAAE
    AgAAAAEABAAJAAAACXZhbHVlX3ZhcgAAABAAAAABAAQACQAAAAV2YWx1ZQAABAIAAAABAAQA
    CQAAAAZpZF92YXIAAAAQAAAAAQAEAAkAAAACaWQAAAQCAAAAAQAEAAkAAAANYmlvbWFya2Vy
    X3ZhcgAAABAAAAABAAQACQAAAAthbnRpZ2VuX2lzbwAAAP4AAAAQAAAAAgAEAAkAAAAISGx5
    RV9JZ0EABAAJAAAACEhseUVfSWdHAAADEwAAAAQAAAAOAAAAyEBPvZ8cWhGVQGR8j88UjJFA
    cgKX0WJtVUBjNCAUq0f3QHr9G+OcRHJAYe6SXP99pkA+jWaabWPuQEqndHRrClpAZAfz5DIt
    gkCBaHYdLtYxQIBmAJf+g/NAjel4yDqIE0A+xpRwVCCRQIXHFd+G4n1ARKrlYQhMPkBI2SCD
    yPSNQG8OgxIillxAccPRX3CQs0Bz9CEho8JwQEuZQWZLC8VAI7Y5UGlyU0Bhz3COpKDPQE1I
    15WuJVBAX0afOVi4KUA3lACvTrOBQGNEUHfCsW9AaGi08mW8D0CABXxifAodQC56fhfvSphA
    dvrO8CLwWUBhUyGJ2VrfQFeDfOsqWflAMbNESzoUmEB6SFPoBEASQEFQm9GqvkpAXUd1GXi1
    N0CE9kJEByRuQGF304doIRdAdeY6t9Sou0BxjF7A0MEJQIBmcQ9W/WRAdV4B6MZ4y0A1vfJx
    4rnCQIk/yeXqujxAS1MEWJU1lEBkJHF4ogXoQE87N5CKnIZAdZAzZr9nrUArDYMeQhb6QHH5
    SKC4xxZAeUpEknG/UEB0mgPpsq/GQF/dcfT2WxBAXey2rgJ2X0BH1lEWx/BiQEqr32u91rxA
    E3NB2DRZjUBXZzqj1l+UQGsoY7Dx6AlAS451ixEOK0BBjJun02ojQF2kQnKuE6FAkSn9GIq9
    okBLDdKJD8tLQE17QL61/hlAYP55+NIWk0BFDehWbKjgQHBJhrcRNIRAQWDFKD2lE0BwFn2m
    D7r5QGZh7jWlQ79AYzY5Cc+f8kA4qri3hlgQQEi45fpSmMNAgfcoSxXzO0Baa8brFJoXQDCN
    EaJq+/xAThoinGAatUAmFzo0fsBNQHzreRYnpytAdJc1nxCdr0B36NGGiHmBQGDHdGAT1ppA
    be7DwdOt4kAsvmt5xRLQQHCJcSht0WJARFcSmKYAGkBMwdf1F+ymQFYRlSk3ckRAeuUbI3dy
    5UAlOd3Vapc6QIFw7Lwmi69AQAG7uP9vTEA4Cdq1/HkPQEMGdHeeAbhAU3iPtBn3I0BftIKE
    JSEtQGP9Zy1QdfBAUXmVRaUPQkBwbiBJEUDYQHYohj8jKe1AecrS312NikBcuxKLanATQF43
    5txcNtNAYJM1LMmOSUBZ3fbC/ysyQHvwGN+IuOxAkPTh5/96jEBAwrH1B6DCQG+kSKeKg3ZA
    YFg5yY3TxkBQuv8DqcNVQHdpUc/9KHVAYXEuUxsvsEBDsw0m81qTQFg6qKvXgUZAZn1s28z4
    +0CXV4eWgnugQC2aDs65mShAeU1udNeTeECApahXJd84QEc6t9XyD/hAOHxfirp5REBIu2uK
    fIeJQFfBdCJ8erVAV34FDd3qQ0BwQtEwr9+xQGG/p9g7o9dAQ/0aiqJy0ECId6KSUbNIQD1p
    JFq57ENAgCUqKqYZm0Bqck/OebSYQJx42jOJkbhASkFBdDUlhUAqTVMyIchXQDNivjkW7BdA
    QZ7WW5zcfkBUPf99boEaQGYli828OehAOl1TgmjOGEBdTmaWULe5QFXBrGh1/b9AX7zWk8Lz
    sUA7NVV8lib7QFT0iohfj/pAUF2Y/mqhZ0BOS7O2oiEZQElD/vZz59BAa4zomJHfNkBM8NTQ
    8CQ1QHQVbXAp0+BAXBUvLf/YL0Bqw6zNsDFAQEciFkh3CHxAb6LOWAzljEBS+UfSpISRQHbL
    UWhTwJVANe2BTunFQUB1YPhE+8BUQFI4gMlK9NVARLBsrQCXJUBGGHhVdxZkQFKvUcmTZidA
    SWoD6YNF0UBwlxnne3woQGyH/7aP9btAYscPEU+JpkBhN3j78sElQHGhTghrtuBAbDAzTWuW
    oEA/MDQEE1TuQGRyF9p4wYtAZsn9QTV7Q0B9QXv1bBnkQDryxW0WqXJAR4gJeyNeOkBwmYYP
    iosYQCZXRL7twEpAZYFUhd5ItUBkIi1/FoCWQHsIQzAa3RVAVk8lBpvDp0BXRBS80XaWQIsb
    C/wlKvNAeSwRsSFqjkAx4RSgdc7HQHIOfZr6gSxANejmY7CmxEBIbBvCWM2AQDXZMIU3aTBA
    ZvJjdyVWgUBFbCsYERpWQHiHIfinZhVAJsl2aGp3MEB0OLuCTPwKQF4UKdUcFs5AZIzu8LQu
    bkBvMaH78bD3QES6TOtlA1wAAAAOAAAAyD9DB69cZmVBP3K7NscmW7A/PhzVuNdbCj9OKlvg
    ovusPzIr3A7/HEw/aA40wQXLYz9UxoHindaMPyhBdjxjXN4/VuZN0D0oJz9Aj/F10w1dPzNF
    vRpphVg/RXPEFojR3D9y0E+tcPUHP00Wd+Y3JvI/YydVqxQJTj8rghWore4JPwh8AgpdgCg/
    UQo6GNSeFT89YTXO+RloPyswqNlJGX8/XjXlRZMkqj9BwLywHu1mPyXAb6GCqV4/amTXXVPh
    Fz9KRGGIAZW4P1MzZdiCN/Q/YWMp2D9zIj9QAcTg9lmsP2DkBRs5Xzc/OTQsbAwZfD9BEZfQ
    CG88P1B9osaS5UE/UhuWGkN9oT8oAwAfDmypP0CDB/S/+Hc/LetAU/g+Wz9f0oj7BmJWPyZ6
    oIYlMVQ/ODp3dD2r9j9RLeFgq5t0P0bYlfFrI24/NGgtBOI0dz83OBZwsWfqP1Ro/S9ceJ0/
    O8iF7T2YRj9KQWxDfAt9P1PEO9wqEjY/Y3obeoM85D9UQH8OMRXXPzd2WU9qBZI/QDEnWkoZ
    Nz8kcpFLfZgcP2Qf84CEGZU/S5MLs7BZEz9fwOBS9zSzP0BKOXmLOMw/dkE4UEuQlz9U28VG
    EpsXP0IQpW5R0Qw/RMam5KFINz9cmWiDENfRPzi2HqfpHqI/P63UybZetj82KlsahmG9P2H6
    5TCkVA8/Vv2Bf5PwgT9RyM0b4KmBP1DXcXRyxBo/bJnxAEG09j83GvlFtI4OP1qNjZDmQNc/
    ZuwCe344mD9gDqr5LKvmPzWpqvfg7DU/N1Ea9p1v7j88wsaxEB4JP1RcaXUFxk8/Qhzq85xX
    oT9eomHzJNEfPzXT+blwsrA/UhWoFdy6CD9X+uHf2kPtPyJEJVakMFY/OgeUyBWPLz9StmTm
    ylouP1BtE86seQM/UeDnUHH8ZD9UxzLlivO4P1Au2EKQl3k/VSIgr6SEeD9nH3Yw1Y74PziP
    9lcwX/c/UqfafHKJOT9BdtseVwLIP0DUtzbhNlk/N465Ufk0RT8yFCY0H60FPzc+3ibkAHw/
    ZeI7/6lKHz9m4lXg/OAsPyDNloEDVDg/eHM8vD4DJT9844yLAGvAP2CSjeVm/5Q/WpLbbk8G
    kT84htnwvTE5PzGIt7Zjwhc/R+/TMuv9Mj9ZGMguPk9LP2qmOVWMZHM/P7XIYTHvfz9DR0hE
    fULAPzONZgwgQ5c/UnOneSSZCj9bocOFJY8ZPyrd1k+Qpfs/X64ziq/kHD9XXx+FHq5lP1YL
    8Q8qRCU/K2AVUN6fvD9EfffumZtCP1XdkhbuvWk/gzkxn459Tz9OtUiMDFKcP0PwlrLmo6g/
    ZaTkXz/imz85sgqey8qHP2sulKBhyUo/XnV/DKwv9D9NuNVfuB1tP1Ljx/6AXKc/MBhtlOrR
    JD9RwjRVcG4IP2B7v5ktdVs/X0i75fH3Uj86y6eDnCdvP0nul4UVVWo/YIERlAmRAT9cGSzc
    nERxP1b1Y7NrIUU/UHPEzbEfaT9BA2o2aImhP1thMZ+mVwQ/S3x+LJqiKD9HpaQKkXViP0CP
    GGWZDbs/Tc0GDVEIaD9T2plG4JuUP0sYPX+dMjs/Z/kenpemZD8z7pV5H2cfP1Ks0qu3jnU/
    OYqw/+mXmD9oc3hQMPLEP0uQ/7be2aI/bibGFYHHmD87pUL4yc81P1RQYppGk+k/SOyV51ak
    iT9YVtl+V3fPP0tLIUJr+LM/M61igOjhzj9fc0r+t3QBPzndzH3hX58/ZfQiT/ATMj9ZGX0c
    yXirP1QCS6rlKEw/OHIKRJS/9T9WAbw/bH1yP0bfBc+ZvIY/SR6tZminQT8wDxXVj09MP0yb
    N9rdpPo/fSsctkgqHj8KHBSCJiFqP08S6gfh2EY/QRrHX8W1+z9UjDgblBXAP0mUuMLgbkw/
    YMpITqwbBz8K1isSR8y7P3b7TY7Vtec/SoEJsX2dsj9HYBBKBsJkP0wpylS0a40/YeKEx/8h
    QT9dj2x+k/XdP0NNpyWYHzU/Q6coDvpXVT9WMeIM1LB3P1d3w61dn8Y/QDgKVxBbKz9D7I7B
    JljnP3J+++KrO2U/a6AWEI4aST83xGS+IjPJPxeRtLxi2zg/N6452S9+lz8xfFiJbsAjP2lP
    1ohTQbQAAAAOAAAAyD/7660CTjBKP/LJZUjqRN5ABU3WQctIVD/0wna70RIXP/nE1J10pGQ/
    8hlTnkpwGT/97BVUgBz6QAEIA/+5F6Q/9lv2rENMlD//mVeQ1BVgQAIVa5FPVT8/+9UQj1Um
    Hz/4xjYRf4mYP/ShplI5A6M/96JJtJsJlD/5vTg3xrp5QCD+JUlAtYw/86VWO0YjfT/7/SNx
    mbyvQAC5X7i0r1w/9AZCenC0nD/6XfqIKp0+P/4N64IP3EM/8rNnwIwMeT/0YiHrJW9eP/bC
    Oq0hI0Y/+blbrLZXWj/zlCoqqaWZP/Iq0NhEYFQ/9z7FNaSi/j/9ZfKAQRPaP/YoWFMfEgk/
    9VnuhCymUEABvqpnN0tEQAcHQhFvIeZAB6WqVyowCj/2C0Vv2A9xP/yabpid0npAC2bhEJpD
    oz/zdkYlYLLPP/e/M0tf2FNAA3rqa/c41j/14wN1t64tP/epgrZNog4/+EHdXZCsjD/zJ2Gj
    MOGPQAZqUXpWzCE/8cfONL+pyD/0wU6LQeaWP/kdASGw58Y/9oDWIUyFc0AAKhZ+g64PP/le
    W19Ykng/9RqkfGSuXD/zquNSJlgaP/qHzWiFetA/+PFb6ro48z/0LytZgVmpP/YIfkgiQdM/
    ++kjS/pJkz/zOpzUhfsDP/cZNgGqIK5AAxSvyeYoHj/+ICOW2aikP/myF6M7owQ/9ZQqasQ1
    dD/57mnlTRLHP/T8Glz1lqpAAQL7tIlvuz/6aX7K4qvWP/evkrr8CDI/8zJ4MvhDSEAABNtW
    UvZcP/tHKtucNgs//e47rSj8Kz/6vycFXJx1P/7ARVmQf8I/+cLFTBIXvD/1mc3DfPDEQAIR
    Oei6kLA/9u8Fqf7YfT/47Sxg9J38QBLi3cLWxEZABKmf93rP8j/3HIsLiHOKP/MYPc2ahZhA
    AEoerPAocz/4AuTpj7kcP/tJIaB7D+A/9OwC9PP/hD/1p8PNh4TiQADtdDupgkY//u9cnt6/
    aT/2gHyjSwbaP/pa1TgbR5lACJC0rGWcdD/6YtsXFBtSP/kW/2gE12o/9f0nwJHoKD/1JP4i
    RLMfP/wn0gS/xug/8IOksNCnbT/zI56lrj/9P/IA7ahXxxRABGGDIeCHAD/6gZ6yr93hP/2A
    Z41/cLY/9f3invEuVj/1b3vvGkWMP/Gz2n6pewhAAYZyBhDarD/5LFaN6enDP/sPc+GXowQ/
    9HaSJa1wuT/3CeFt3/FSQAwlcSKHtuo/93goqeTsBj/1mFPklCTOP/edOh0vJVQ//G+yQkaC
    QD//ycBVFugCP/Pnwstpfx8/8tPlFdLYbD/z/0R3d9kbP/7rurtKi+k/9FURp00dBkABNmj8
    j/MkP/GO/nE6eM0/+QkyobtquT/0P7/fkq5LP/foJ/ghV5A//eQ1UezBkT/6sjjj5nomP/I4
    Y5oYWx5ADyHwDDG9X0ACJojhv61iP/+8cVhJsaE/8c8f5tQkzD/03II+lPUoP/HvHjbUM0k/
    9U2vTk24Jz/+843zxQF3P/X9sretKnA/+UBR8nWg6kAC8n5xq8RGP/6AoQ8VJI4/+2hx1aoQ
    OT/2+nW0eGWwQAL8KB81bQo/8pHANb6zlT//CPMa9ghXP/NM0FCxsIY/89+i1PEdyT/xw2j6
    LR7/P/Rp75XUo9k/8mmtZBiwBkABLMUSc7B4P/R17mThzWJAAcWYbzkkqD/0osnYqxToP/bW
    S8NbnxlAApY4PzqqHD/56bETJ9E5P/eZTyGO4WI/+I+vfa2aFT/z5+kwMu5IP/OzkMr+7/U/
    /9ibmPD+VD/4SMGtMTKXP/UbpiaFbzs/+c8LcnRUQj/1CKGxLXOBP/bfrvEjV7Q/8JIOMEXp
    R0ATNI7Ze+5OP/YyqneGBB4/+PAnIuJfRj/4bTOkwoKlQAJRvWIiZnc/8nO/EBlVM0AY9AkC
    f7sAP/GVf4LqtgQ/+onw5RCk2j/4AlQGPMfqP/9MxscTSW8/8nkmNNlEKz/3ggHClZBDP/ZE
    cyVtNTg/+nbkxXnSQD/0THlQQA1sQAVvqQdRMp4//7cvk5f5vkACk72yCp3OP/F4IWir+PxA
    AStJLhKQmD/8qvBGvvfsQASGT1SWiZI//TitqiFH00AB7oHcQVK2P/JGzRy3yvgAAAMNAAAA
    yAAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEA
    AAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAA
    AQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIA
    AAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAA
    AgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEA
    AAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAA
    AQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIA
    AAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAA
    AgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEA
    AAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAA
    AQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIA
    AAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAA
    AgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEA
    AAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAA
    AQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAEAgAAAf8A
    AAAQAAAABQAEAAkAAAAISGx5RV9JZ0EABAAJAAAACEhseUVfSWdHAAQACQAAAAdMUFNfSWdB
    AAQACQAAAAdMUFNfSWdHAAQACQAAAAZWaV9JZ0cAAAQCAAAC/wAAABAAAAABAAQACQAAAAZm
    YWN0b3IAAAD+AAAEAgAAA/8AAAAQAAAABAAEAAkAAAACeTEABAAJAAAABWFscGhhAAQACQAA
    AAFyAAQACQAAAAthbnRpZ2VuX2lzbwAABAIAAAT/AAAADQAAAAKAAAAA////OAAABAIAAAL/
    AAAAEAAAAAQABAAJAAAADGN1cnZlX3BhcmFtcwAEAAkAAAAGdGJsX2RmAAQACQAAAAN0YmwA
    BAAJAAAACmRhdGEuZnJhbWUAAAQCAAAF/wAAAw0AAAAFAAAAAQAAAAIAAAADAAAABAAAAAUA
    AAQCAAAB/wAAABAAAAAFAAQACQAAAAhIbHlFX0lnQQAEAAkAAAAISGx5RV9JZ0cABAAJAAAA
    B0xQU19JZ0EABAAJAAAAB0xQU19JZ0cABAAJAAAABlZpX0lnRwAABAIAAAL/AAAAEAAAAAEA
    BAAJAAAABmZhY3RvcgAAAP4AAAQCAAAJ/wAAABAAAAABAAQACQAAAAthbnRpZ2VuX2lzbwAA
    AP4AAAMTAAAABQAAAA4AAAACQATDzgANHOhAAuFiospgWAAAAA4AAAACP9HgZLISU5g/wqRX
    3cpmjwAAAA4AAAACP+BFPcbXYck/+YNhwTKHMwAAAA4AAAACQVMS0AAAAABBUxLQAAAAAAAA
    ABAAAAACAAQACQAAAAhIbHlFX0lnQQAEAAkAAAAISGx5RV9JZ0cAAAQCAAAD/wAAABAAAAAF
    AAQACQAAAAJudQAEAAkAAAADZXBzAAQACQAAAAV5LmxvdwAEAAkAAAAGeS5oaWdoAAQACQAA
    AAthbnRpZ2VuX2lzbwAABAIAAAT/AAAADQAAAAKAAAAA/////gAABAIAAAL/AAAAEAAAAAQA
    BAAJAAAADG5vaXNlX3BhcmFtcwAEAAkAAAAGdGJsX2RmAAQACQAAAAN0YmwABAAJAAAACmRh
    dGEuZnJhbWUAAAQCAAAF/wAAABAAAAAEAAQACQAAAAhIbHlFX0lnQQAEAAkAAAAISGx5RV9J
    Z0cABAAJAAAAB0xQU19JZ0EABAAJAAAAB0xQU19JZ0cAAAD+AAAEAgAAA/8AAAAQAAAABAAE
    AAkAAAAIcG9wX2RhdGEABAAJAAAADGFudGlnZW5faXNvcwAEAAkAAAAJc3JfcGFyYW1zAAQA
    CQAAAAxub2lzZV9wYXJhbXMAAAQCAAAC/wAAABAAAAACAAQACQAAABliaW9tYXJrZXJfZGF0
    YV9hbmRfcGFyYW1zAAQACQAAAARsaXN0AAAA/gAAAxMAAAAEAAADEwAAAAMAAAAOAAAAXj/i
    LYdMuu6pP+jvr8G1UsQ//lrLxyR9dD/2ir5P5PhFQBx2Da9ItgUAAAAAAAAAAEAHOZobY3eN
    P/cc5oT8IBlADh8WojZ+y0AGXhhx1Z8dQBGUZwCMjzxAOiWx2ddMWEAEwSZqouEWQAmuafVV
    8b4/3zqF+WTsekAFQvTf7vEYP+9lQYsPvg4/93h9SKsUlkAjXLS4YY5uQEbRXyNREu1AOX/0
    TRljU0AQJ+7iuw96QA6z242WEWBAOk84dj4fy0AR6NB+5piDP/pGvDFAjC9ADknyUyHDqD/t
    tcMsIFWcQAqSK/he/3JAEEenh1zE7EAJxx8x2qnAQADbXDLCBVpABrvisisktkASHp0E7zlF
    QATZ8P0lJqI/5WCtqCH7MEAGrkF9my27QA3ZW34q/jBADH5DOB88bD/sYa3wcUpOQA9+5ic7
    2R9ACGeEawChXT/oFIxqDsUdQADHNMxLrrtADSgAPmlHQUABTzUISnxQQCrKfRxgXeRAATmW
    QSgcBj/+S0v8NXi7QCAs3cNqIolAAvzo3ERbcUAnNEkwH61vP9cyHDQKlf0//p2AXH4nm0AA
    S6oIlmtWQAi9dPaZcU1AFTTChSA63kARJNi+v+YsQB8m6tRSWslAE3OTEmNRVUAAkOM7CXyS
    P+A4yf2G9ktAKAcjTbfuxEAGSWqW96jEP+bRUb38lCpAI5cySucVNEAwBPCsT/+dP/Hem+5M
    aCdAMKqGpPVCYkA+Tv3VLW54QFAhZP5cZt4//vWqrgLL/D/+Ae0NTeAiQBZI2nfbLeQ//UBc
    iORiDEA8lHTqN8G4QBeRPAXiDqBABhiec/Pto0AE3iTBq1uOQAQXtutBtYtAD15v+39WkUAg
    EaSg+HdkP9sfSeiSjEVAIEvAvTAy30ABg+uTJVAKQB6I+HnxKhxAAbgObuE8zz/wvdPn0b6C
    QA1so/7EuPk/82CjcqUn3EAAkdIxmTLKQC1ne1Y3miBABXVXTAYBvEBA1RhEmmPEAAAADgAA
    AF5AKmZmZmZmZkAmAAAAAAAAQCgAAAAAAABAMAAAAAAAAEAeZmZmZmZmQAJmZmZmZmZAEAAA
    AAAAAEAUZmZmZmZmQDKzMzMzMzNAHAAAAAAAAEAVmZmZmZmaQBAAAAAAAABANDMzMzMzM0Ao
    ZmZmZmZmQBpmZmZmZmZAIgAAAAAAAEAdMzMzMzMzQAmZmZmZmZpAMDMzMzMzM0A3AAAAAAAA
    QC6ZmZmZmZpAK8zMzMzMzUAYAAAAAAAAQBLMzMzMzM1AHzMzMzMzM0AlzMzMzMzNQDdMzMzM
    zM1ADmZmZmZmZkAkAAAAAAAAQCgAAAAAAABAOAAAAAAAAEAvZmZmZmZmQC4AAAAAAABANwAA
    AAAAAEAzAAAAAAAAQAMzMzMzMzNAHAAAAAAAAEAz5mZmZmZmQDQAAAAAAABAGzMzMzMzM0Ai
    AAAAAAAAQB2ZmZmZmZpAHgAAAAAAAEAsAAAAAAAAQDEAAAAAAABALDMzMzMzM0AoAAAAAAAA
    QCpmZmZmZmZAJgAAAAAAAEAoAAAAAAAAQDAAAAAAAABAHmZmZmZmZkACZmZmZmZmQBAAAAAA
    AABAFGZmZmZmZkAyszMzMzMzQBwAAAAAAABAFZmZmZmZmkAQAAAAAAAAQDQzMzMzMzNAKGZm
    ZmZmZkAaZmZmZmZmQCIAAAAAAABAHTMzMzMzM0AJmZmZmZmaQDAzMzMzMzNANwAAAAAAAEAu
    mZmZmZmaQCvMzMzMzM1AGAAAAAAAAEASzMzMzMzNQB8zMzMzMzNAJczMzMzMzUA3TMzMzMzN
    QA5mZmZmZmZAJAAAAAAAAEAoAAAAAAAAQDgAAAAAAABAL2ZmZmZmZkAuAAAAAAAAQDcAAAAA
    AABAMwAAAAAAAEADMzMzMzMzQBwAAAAAAABAM+ZmZmZmZkA0AAAAAAAAQBszMzMzMzNAIgAA
    AAAAAEAdmZmZmZmaQB4AAAAAAABALAAAAAAAAEAxAAAAAAAAQCwzMzMzMzNAKAAAAAAAAAAA
    Aw0AAABeAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAAB
    AAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAA
    AAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAAB
    AAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAACAAAAAgAAAAIAAAACAAAAAgAA
    AAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAAC
    AAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAA
    AAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAAC
    AAAAAgAABAIAAAH/AAAAEAAAAAIABAAJAAAACEhseUVfSWdBAAQACQAAAAhIbHlFX0lnRwAA
    BAIAAAL/AAAAEAAAAAEABAAJAAAABmZhY3RvcgAAAP4AAAQCAAAD/wAAABAAAAADAAQACQAA
    AAV2YWx1ZQAEAAkAAAADYWdlAAQACQAAAAthbnRpZ2VuX2lzbwAABAIAAAT/AAAADQAAAAKA
    AAAA////ogAABAIAAAL/AAAAEAAAAAQABAAJAAAACHBvcF9kYXRhAAQACQAAAAZ0YmxfZGYA
    BAAJAAAAA3RibAAEAAkAAAAKZGF0YS5mcmFtZQAABAIAAAX/AAAAEAAAAAIABAAJAAAACEhs
    eUVfSWdBAAQACQAAAAhIbHlFX0lnRwAABAIAAAb/AAAAEAAAAAEABAAJAAAAA2FnZQAABAIA
    AAf/AAAAEAAAAAEABAAJAAAABXZhbHVlAAAEAgAACP8AAAAQAAAAAQAEAAkAAAACaWQAAAQC
    AAAJ/wAAABAAAAABAAQACQAAAAthbnRpZ2VuX2lzbwAAAP4AAAAQAAAAAgAEAAkAAAAISGx5
    RV9JZ0EABAAJAAAACEhseUVfSWdHAAADEwAAAAQAAAAOAAAAyEBPvZ8cWhGVQGR8j88UjJFA
    cgKX0WJtVUBjNCAUq0f3QHr9G+OcRHJAYe6SXP99pkA+jWaabWPuQEqndHRrClpAZAfz5DIt
    gkCBaHYdLtYxQIBmAJf+g/NAjel4yDqIE0A+xpRwVCCRQIXHFd+G4n1ARKrlYQhMPkBI2SCD
    yPSNQG8OgxIillxAccPRX3CQs0Bz9CEho8JwQEuZQWZLC8VAI7Y5UGlyU0Bhz3COpKDPQE1I
    15WuJVBAX0afOVi4KUA3lACvTrOBQGNEUHfCsW9AaGi08mW8D0CABXxifAodQC56fhfvSphA
    dvrO8CLwWUBhUyGJ2VrfQFeDfOsqWflAMbNESzoUmEB6SFPoBEASQEFQm9GqvkpAXUd1GXi1
    N0CE9kJEByRuQGF304doIRdAdeY6t9Sou0BxjF7A0MEJQIBmcQ9W/WRAdV4B6MZ4y0A1vfJx
    4rnCQIk/yeXqujxAS1MEWJU1lEBkJHF4ogXoQE87N5CKnIZAdZAzZr9nrUArDYMeQhb6QHH5
    SKC4xxZAeUpEknG/UEB0mgPpsq/GQF/dcfT2WxBAXey2rgJ2X0BH1lEWx/BiQEqr32u91rxA
    E3NB2DRZjUBXZzqj1l+UQGsoY7Dx6AlAS451ixEOK0BBjJun02ojQF2kQnKuE6FAkSn9GIq9
    okBLDdKJD8tLQE17QL61/hlAYP55+NIWk0BFDehWbKjgQHBJhrcRNIRAQWDFKD2lE0BwFn2m
    D7r5QGZh7jWlQ79AYzY5Cc+f8kA4qri3hlgQQEi45fpSmMNAgfcoSxXzO0Baa8brFJoXQDCN
    EaJq+/xAThoinGAatUAmFzo0fsBNQHzreRYnpytAdJc1nxCdr0B36NGGiHmBQGDHdGAT1ppA
    be7DwdOt4kAsvmt5xRLQQHCJcSht0WJARFcSmKYAGkBMwdf1F+ymQFYRlSk3ckRAeuUbI3dy
    5UAlOd3Vapc6QIFw7Lwmi69AQAG7uP9vTEA4Cdq1/HkPQEMGdHeeAbhAU3iPtBn3I0BftIKE
    JSEtQGP9Zy1QdfBAUXmVRaUPQkBwbiBJEUDYQHYohj8jKe1AecrS312NikBcuxKLanATQF43
    5txcNtNAYJM1LMmOSUBZ3fbC/ysyQHvwGN+IuOxAkPTh5/96jEBAwrH1B6DCQG+kSKeKg3ZA
    YFg5yY3TxkBQuv8DqcNVQHdpUc/9KHVAYXEuUxsvsEBDsw0m81qTQFg6qKvXgUZAZn1s28z4
    +0CXV4eWgnugQC2aDs65mShAeU1udNeTeECApahXJd84QEc6t9XyD/hAOHxfirp5REBIu2uK
    fIeJQFfBdCJ8erVAV34FDd3qQ0BwQtEwr9+xQGG/p9g7o9dAQ/0aiqJy0ECId6KSUbNIQD1p
    JFq57ENAgCUqKqYZm0Bqck/OebSYQJx42jOJkbhASkFBdDUlhUAqTVMyIchXQDNivjkW7BdA
    QZ7WW5zcfkBUPf99boEaQGYli828OehAOl1TgmjOGEBdTmaWULe5QFXBrGh1/b9AX7zWk8Lz
    sUA7NVV8lib7QFT0iohfj/pAUF2Y/mqhZ0BOS7O2oiEZQElD/vZz59BAa4zomJHfNkBM8NTQ
    8CQ1QHQVbXAp0+BAXBUvLf/YL0Bqw6zNsDFAQEciFkh3CHxAb6LOWAzljEBS+UfSpISRQHbL
    UWhTwJVANe2BTunFQUB1YPhE+8BUQFI4gMlK9NVARLBsrQCXJUBGGHhVdxZkQFKvUcmTZidA
    SWoD6YNF0UBwlxnne3woQGyH/7aP9btAYscPEU+JpkBhN3j78sElQHGhTghrtuBAbDAzTWuW
    oEA/MDQEE1TuQGRyF9p4wYtAZsn9QTV7Q0B9QXv1bBnkQDryxW0WqXJAR4gJeyNeOkBwmYYP
    iosYQCZXRL7twEpAZYFUhd5ItUBkIi1/FoCWQHsIQzAa3RVAVk8lBpvDp0BXRBS80XaWQIsb
    C/wlKvNAeSwRsSFqjkAx4RSgdc7HQHIOfZr6gSxANejmY7CmxEBIbBvCWM2AQDXZMIU3aTBA
    ZvJjdyVWgUBFbCsYERpWQHiHIfinZhVAJsl2aGp3MEB0OLuCTPwKQF4UKdUcFs5AZIzu8LQu
    bkBvMaH78bD3QES6TOtlA1wAAAAOAAAAyD9DB69cZmVBP3K7NscmW7A/PhzVuNdbCj9OKlvg
    ovusPzIr3A7/HEw/aA40wQXLYz9UxoHindaMPyhBdjxjXN4/VuZN0D0oJz9Aj/F10w1dPzNF
    vRpphVg/RXPEFojR3D9y0E+tcPUHP00Wd+Y3JvI/YydVqxQJTj8rghWore4JPwh8AgpdgCg/
    UQo6GNSeFT89YTXO+RloPyswqNlJGX8/XjXlRZMkqj9BwLywHu1mPyXAb6GCqV4/amTXXVPh
    Fz9KRGGIAZW4P1MzZdiCN/Q/YWMp2D9zIj9QAcTg9lmsP2DkBRs5Xzc/OTQsbAwZfD9BEZfQ
    CG88P1B9osaS5UE/UhuWGkN9oT8oAwAfDmypP0CDB/S/+Hc/LetAU/g+Wz9f0oj7BmJWPyZ6
    oIYlMVQ/ODp3dD2r9j9RLeFgq5t0P0bYlfFrI24/NGgtBOI0dz83OBZwsWfqP1Ro/S9ceJ0/
    O8iF7T2YRj9KQWxDfAt9P1PEO9wqEjY/Y3obeoM85D9UQH8OMRXXPzd2WU9qBZI/QDEnWkoZ
    Nz8kcpFLfZgcP2Qf84CEGZU/S5MLs7BZEz9fwOBS9zSzP0BKOXmLOMw/dkE4UEuQlz9U28VG
    EpsXP0IQpW5R0Qw/RMam5KFINz9cmWiDENfRPzi2HqfpHqI/P63UybZetj82KlsahmG9P2H6
    5TCkVA8/Vv2Bf5PwgT9RyM0b4KmBP1DXcXRyxBo/bJnxAEG09j83GvlFtI4OP1qNjZDmQNc/
    ZuwCe344mD9gDqr5LKvmPzWpqvfg7DU/N1Ea9p1v7j88wsaxEB4JP1RcaXUFxk8/Qhzq85xX
    oT9eomHzJNEfPzXT+blwsrA/UhWoFdy6CD9X+uHf2kPtPyJEJVakMFY/OgeUyBWPLz9StmTm
    ylouP1BtE86seQM/UeDnUHH8ZD9UxzLlivO4P1Au2EKQl3k/VSIgr6SEeD9nH3Yw1Y74PziP
    9lcwX/c/UqfafHKJOT9BdtseVwLIP0DUtzbhNlk/N465Ufk0RT8yFCY0H60FPzc+3ibkAHw/
    ZeI7/6lKHz9m4lXg/OAsPyDNloEDVDg/eHM8vD4DJT9844yLAGvAP2CSjeVm/5Q/WpLbbk8G
    kT84htnwvTE5PzGIt7Zjwhc/R+/TMuv9Mj9ZGMguPk9LP2qmOVWMZHM/P7XIYTHvfz9DR0hE
    fULAPzONZgwgQ5c/UnOneSSZCj9bocOFJY8ZPyrd1k+Qpfs/X64ziq/kHD9XXx+FHq5lP1YL
    8Q8qRCU/K2AVUN6fvD9EfffumZtCP1XdkhbuvWk/gzkxn459Tz9OtUiMDFKcP0PwlrLmo6g/
    ZaTkXz/imz85sgqey8qHP2sulKBhyUo/XnV/DKwv9D9NuNVfuB1tP1Ljx/6AXKc/MBhtlOrR
    JD9RwjRVcG4IP2B7v5ktdVs/X0i75fH3Uj86y6eDnCdvP0nul4UVVWo/YIERlAmRAT9cGSzc
    nERxP1b1Y7NrIUU/UHPEzbEfaT9BA2o2aImhP1thMZ+mVwQ/S3x+LJqiKD9HpaQKkXViP0CP
    GGWZDbs/Tc0GDVEIaD9T2plG4JuUP0sYPX+dMjs/Z/kenpemZD8z7pV5H2cfP1Ks0qu3jnU/
    OYqw/+mXmD9oc3hQMPLEP0uQ/7be2aI/bibGFYHHmD87pUL4yc81P1RQYppGk+k/SOyV51ak
    iT9YVtl+V3fPP0tLIUJr+LM/M61igOjhzj9fc0r+t3QBPzndzH3hX58/ZfQiT/ATMj9ZGX0c
    yXirP1QCS6rlKEw/OHIKRJS/9T9WAbw/bH1yP0bfBc+ZvIY/SR6tZminQT8wDxXVj09MP0yb
    N9rdpPo/fSsctkgqHj8KHBSCJiFqP08S6gfh2EY/QRrHX8W1+z9UjDgblBXAP0mUuMLgbkw/
    YMpITqwbBz8K1isSR8y7P3b7TY7Vtec/SoEJsX2dsj9HYBBKBsJkP0wpylS0a40/YeKEx/8h
    QT9dj2x+k/XdP0NNpyWYHzU/Q6coDvpXVT9WMeIM1LB3P1d3w61dn8Y/QDgKVxBbKz9D7I7B
    JljnP3J+++KrO2U/a6AWEI4aST83xGS+IjPJPxeRtLxi2zg/N6452S9+lz8xfFiJbsAjP2lP
    1ohTQbQAAAAOAAAAyD/7660CTjBKP/LJZUjqRN5ABU3WQctIVD/0wna70RIXP/nE1J10pGQ/
    8hlTnkpwGT/97BVUgBz6QAEIA/+5F6Q/9lv2rENMlD//mVeQ1BVgQAIVa5FPVT8/+9UQj1Um
    Hz/4xjYRf4mYP/ShplI5A6M/96JJtJsJlD/5vTg3xrp5QCD+JUlAtYw/86VWO0YjfT/7/SNx
    mbyvQAC5X7i0r1w/9AZCenC0nD/6XfqIKp0+P/4N64IP3EM/8rNnwIwMeT/0YiHrJW9eP/bC
    Oq0hI0Y/+blbrLZXWj/zlCoqqaWZP/Iq0NhEYFQ/9z7FNaSi/j/9ZfKAQRPaP/YoWFMfEgk/
    9VnuhCymUEABvqpnN0tEQAcHQhFvIeZAB6WqVyowCj/2C0Vv2A9xP/yabpid0npAC2bhEJpD
    oz/zdkYlYLLPP/e/M0tf2FNAA3rqa/c41j/14wN1t64tP/epgrZNog4/+EHdXZCsjD/zJ2Gj
    MOGPQAZqUXpWzCE/8cfONL+pyD/0wU6LQeaWP/kdASGw58Y/9oDWIUyFc0AAKhZ+g64PP/le
    W19Ykng/9RqkfGSuXD/zquNSJlgaP/qHzWiFetA/+PFb6ro48z/0LytZgVmpP/YIfkgiQdM/
    ++kjS/pJkz/zOpzUhfsDP/cZNgGqIK5AAxSvyeYoHj/+ICOW2aikP/myF6M7owQ/9ZQqasQ1
    dD/57mnlTRLHP/T8Glz1lqpAAQL7tIlvuz/6aX7K4qvWP/evkrr8CDI/8zJ4MvhDSEAABNtW
    UvZcP/tHKtucNgs//e47rSj8Kz/6vycFXJx1P/7ARVmQf8I/+cLFTBIXvD/1mc3DfPDEQAIR
    Oei6kLA/9u8Fqf7YfT/47Sxg9J38QBLi3cLWxEZABKmf93rP8j/3HIsLiHOKP/MYPc2ahZhA
    AEoerPAocz/4AuTpj7kcP/tJIaB7D+A/9OwC9PP/hD/1p8PNh4TiQADtdDupgkY//u9cnt6/
    aT/2gHyjSwbaP/pa1TgbR5lACJC0rGWcdD/6YtsXFBtSP/kW/2gE12o/9f0nwJHoKD/1JP4i
    RLMfP/wn0gS/xug/8IOksNCnbT/zI56lrj/9P/IA7ahXxxRABGGDIeCHAD/6gZ6yr93hP/2A
    Z41/cLY/9f3invEuVj/1b3vvGkWMP/Gz2n6pewhAAYZyBhDarD/5LFaN6enDP/sPc+GXowQ/
    9HaSJa1wuT/3CeFt3/FSQAwlcSKHtuo/93goqeTsBj/1mFPklCTOP/edOh0vJVQ//G+yQkaC
    QD//ycBVFugCP/Pnwstpfx8/8tPlFdLYbD/z/0R3d9kbP/7rurtKi+k/9FURp00dBkABNmj8
    j/MkP/GO/nE6eM0/+QkyobtquT/0P7/fkq5LP/foJ/ghV5A//eQ1UezBkT/6sjjj5nomP/I4
    Y5oYWx5ADyHwDDG9X0ACJojhv61iP/+8cVhJsaE/8c8f5tQkzD/03II+lPUoP/HvHjbUM0k/
    9U2vTk24Jz/+843zxQF3P/X9sretKnA/+UBR8nWg6kAC8n5xq8RGP/6AoQ8VJI4/+2hx1aoQ
    OT/2+nW0eGWwQAL8KB81bQo/8pHANb6zlT//CPMa9ghXP/NM0FCxsIY/89+i1PEdyT/xw2j6
    LR7/P/Rp75XUo9k/8mmtZBiwBkABLMUSc7B4P/R17mThzWJAAcWYbzkkqD/0osnYqxToP/bW
    S8NbnxlAApY4PzqqHD/56bETJ9E5P/eZTyGO4WI/+I+vfa2aFT/z5+kwMu5IP/OzkMr+7/U/
    /9ibmPD+VD/4SMGtMTKXP/UbpiaFbzs/+c8LcnRUQj/1CKGxLXOBP/bfrvEjV7Q/8JIOMEXp
    R0ATNI7Ze+5OP/YyqneGBB4/+PAnIuJfRj/4bTOkwoKlQAJRvWIiZnc/8nO/EBlVM0AY9AkC
    f7sAP/GVf4LqtgQ/+onw5RCk2j/4AlQGPMfqP/9MxscTSW8/8nkmNNlEKz/3ggHClZBDP/ZE
    cyVtNTg/+nbkxXnSQD/0THlQQA1sQAVvqQdRMp4//7cvk5f5vkACk72yCp3OP/F4IWir+PxA
    AStJLhKQmD/8qvBGvvfsQASGT1SWiZI//TitqiFH00AB7oHcQVK2P/JGzRy3yvgAAAMNAAAA
    yAAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEA
    AAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAA
    AQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIA
    AAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAA
    AgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEA
    AAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAA
    AQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIA
    AAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAA
    AgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEA
    AAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAA
    AQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIA
    AAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAA
    AgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEA
    AAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAA
    AQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAEAgAAAf8A
    AAAQAAAABQAEAAkAAAAISGx5RV9JZ0EABAAJAAAACEhseUVfSWdHAAQACQAAAAdMUFNfSWdB
    AAQACQAAAAdMUFNfSWdHAAQACQAAAAZWaV9JZ0cAAAQCAAAC/wAAABAAAAABAAQACQAAAAZm
    YWN0b3IAAAD+AAAEAgAAA/8AAAAQAAAABAAEAAkAAAACeTEABAAJAAAABWFscGhhAAQACQAA
    AAFyAAQACQAAAAthbnRpZ2VuX2lzbwAABAIAAAT/AAAADQAAAAKAAAAA////OAAABAIAAAL/
    AAAAEAAAAAQABAAJAAAADGN1cnZlX3BhcmFtcwAEAAkAAAAGdGJsX2RmAAQACQAAAAN0YmwA
    BAAJAAAACmRhdGEuZnJhbWUAAAQCAAAF/wAAAw0AAAAFAAAAAQAAAAIAAAADAAAABAAAAAUA
    AAQCAAAB/wAAABAAAAAFAAQACQAAAAhIbHlFX0lnQQAEAAkAAAAISGx5RV9JZ0cABAAJAAAA
    B0xQU19JZ0EABAAJAAAAB0xQU19JZ0cABAAJAAAABlZpX0lnRwAABAIAAAL/AAAAEAAAAAEA
    BAAJAAAABmZhY3RvcgAAAP4AAAQCAAAJ/wAAABAAAAABAAQACQAAAAthbnRpZ2VuX2lzbwAA
    AP4AAAMTAAAABQAAAA4AAAACQATDzgANHOhAAuFiospgWAAAAA4AAAACP9HgZLISU5g/wqRX
    3cpmjwAAAA4AAAACP+BFPcbXYck/+YNhwTKHMwAAAA4AAAACQVMS0AAAAABBUxLQAAAAAAAA
    ABAAAAACAAQACQAAAAhIbHlFX0lnQQAEAAkAAAAISGx5RV9JZ0cAAAQCAAAD/wAAABAAAAAF
    AAQACQAAAAJudQAEAAkAAAADZXBzAAQACQAAAAV5LmxvdwAEAAkAAAAGeS5oaWdoAAQACQAA
    AAthbnRpZ2VuX2lzbwAABAIAAAT/AAAADQAAAAKAAAAA/////gAABAIAAAL/AAAAEAAAAAQA
    BAAJAAAADG5vaXNlX3BhcmFtcwAEAAkAAAAGdGJsX2RmAAQACQAAAAN0YmwABAAJAAAACmRh
    dGEuZnJhbWUAAAQCAAAF/wAAABAAAAAEAAQACQAAAAhIbHlFX0lnQQAEAAkAAAAISGx5RV9J
    Z0cABAAJAAAAB0xQU19JZ0EABAAJAAAAB0xQU19JZ0cAAAD+AAAEAgAAA/8AAAAQAAAABAAE
    AAkAAAAIcG9wX2RhdGEABAAJAAAADGFudGlnZW5faXNvcwAEAAkAAAAJc3JfcGFyYW1zAAQA
    CQAAAAxub2lzZV9wYXJhbXMAAAQCAAAC/wAAABAAAAACAAQACQAAABliaW9tYXJrZXJfZGF0
    YV9hbmRfcGFyYW1zAAQACQAAAARsaXN0AAAA/gAABAIAAAP/AAAAEAAAAAIABAAJAAAACVN0
    cmF0dW0gMQAEAAkAAAAJU3RyYXR1bSAyAAAEAgAABf8AAAAQAAAAAgAEAAkAAAAISGx5RV9J
    Z0EABAAJAAAACEhseUVfSWdHAAAEAgAAAAEABAAJAAAABnN0cmF0YQAAAxMAAAADAAAAEAAA
    AAIABAAJAAAACVN0cmF0dW0gMQAEAAkAAAAJU3RyYXR1bSAyAAAAEAAAAAIABAAJAAAAA2Fr
    dQAEAAkAAAADa2doAAAADQAAAAIAAAA1AAAALwAABAIAAAP/AAAAEAAAAAMABAAJAAAAB1N0
    cmF0dW0ABAAJAAAACWNhdGNobWVudAAEAAkAAAABbgAABAIAAAT/AAAADQAAAAKAAAAA////
    /gAABAIAAAL/AAAAEAAAAAMABAAJAAAABnRibF9kZgAEAAkAAAADdGJsAAQACQAAAApkYXRh
    LmZyYW1lAAAEAgAAAAEABAAJAAAAC3N0cmF0YV92YXJzAAAAEAAAAAEABAAJAAAACWNhdGNo
    bWVudAAAAP4AAAQCAAAC/wAAABAAAAACAAQACQAAAB5iaW9tYXJrZXJfZGF0YV9hbmRfcGFy
    YW1zLmxpc3QABAAJAAAABGxpc3QAAAD+

# stratify_data() produces consistent results with no strata

    WAoAAAACAAQEAQACAwAAAAITAAAAAQAAAxMAAAAEAAADEwAAAAMAAAAOAAAAyD/iLYdMuu6p
    QBa+jE14JU0/86fO30MTcj/xW0jz5L6xP/beNg0cDBRACH7SvbAs4j/o76/BtVLEP/5ay8ck
    fXQ/9oq+T+T4RUAI08kFQgk6P5+FlLKHr8BAHHYNr0i2BQAAAAAAAAAAQAc5mhtjd41AGY/x
    P8jC0j/3HOaE/CAZQA4fFqI2fstABl4YcdWfHUARlGcAjI88QDolsdnXTFg/zsXBZnhrMkAL
    od8ymcoFQATBJmqi4RY/4qiB2sdHjj/zP6iacQ2SQCzmwGY3FphAK1laBVoHCEAjgnvyab9h
    QAmuafVV8b4//axoNPs9AEAq9DNNikx1P986hflk7HpAD1JSj3eKWT/inhv4C8hpQAVC9N/u
    8Rg/72VBiw++Dj/3eH1IqxSWQCNctLhhjm4/3cIMm1UWxEBG0V8jURLtQDl/9E0ZY1M/6cCk
    YynOjj/F2cHIC/LSQBAn7uK7D3o/9e+nzeTPzkAI76MWEYazQA6z242WEWBAOk84dj4fy0AR
    6NB+5piDP+Q0e3gkBqM/+ka8MUCMLz/dQDI1w2yNQA5J8lMhw6hAA2cUtI9gqD/7TI4NFd+I
    QA0aR0DtbDs/7bXDLCBVnEBReU2QS+gLQALLSX96329AA2A4FJlqH0AX1hz60VvCQAqSK/he
    /3JAEEenh1zE7D/zVozOHfR2QDWrN65CHTE//7D1Mq24cUAbyn5SSQCuP9Te2IHQk/A/+/MX
    ghaJ9EAW+akENIbfQFCXmtTixd1AIS9sODd+8kAjHnyycfF5P/dpT6AD9Io/+s/Eo1T7p0AA
    A6yaypOEP/9phywdhA4/wm6fSUq7f0AFILh/fKazQAUeUbiVmWtALfF22fwKUkAJxx8x2qnA
    QADbXDLCBVpABrvisisktkASHp0E7zlFQATZ8P0lJqI/5WCtqCH7MEAGrkF9my27QA3ZW34q
    /jBADH5DOB88bD/sYa3wcUpOP+KdzvSJGDFAD37mJzvZH0AIZ4RrAKFdP+gUjGoOxR0/+Y/y
    1t3Y9UAAxzTMS667QA0oAD5pR0FAAU81CEp8UEAqyn0cYF3kQAE5lkEoHAZAENhrLVMn+UAI
    A/vlNZu7P8vDraEv3WA/7psiGuWSHkAjJLsgL6juP/5LS/w1eLtAICzdw2oiiUAC/OjcRFtx
    P/WsR0m3/FM/8FEgxtssckAnNEkwH61vP9cyHDQKlf0//p2AXH4nm0BAzp556KREQABLqgiW
    a1ZACL109plxTUAVNMKFIDreQBEk2L6/5ixAHybq1FJayT/N/jBpdrOIP/+EsjZZv3VAE3OT
    EmNRVT//m3932lckP9efLkfVxl9ADoHeoLTA50AaQh51HEfwQBwtMWowSnZAAJDjOwl8kkAD
    W8/ze2rjQBZ0tIwFqbA/4DjJ/Yb2Sz/lrKxuu/37P9uU8RV42n9AKAcjTbfuxEAGSWqW96jE
    P+bRUb38lCpAI5cySucVND/vdHDCV0phQDAE8KxP/50/8d6b7kxoJz/WN/sZEHI+P+W5zMXJ
    gPFAMKqGpPVCYj/1+MIFJjgsP/W7A9J7FShAPk791S1ueEBQIWT+XGbeP/71qq4Cy/w/+bmd
    2ZGjoz/+Ae0NTeAiP+Usm7y0e8hAFkjad9st5EAN2vUKWJ59QAA6xl16jRhACKyb435yqj/9
    QFyI5GIMQDBttttz2ZdAEGZ5NhCh/kAz+HxpXRDSQCCXnnnkWMFAPJR06jfBuEAXkTwF4g6g
    QCwWqQXIQPdAG9W222tCkUAMLzzzyLGCQCOjnnnkWME/0C2xNY76fD/sBO44Gz45P/FtA87s
    jLFAGTzzz0UiHkAXHtJtj2lZQBU7fkR+ih8/8Veur+d1AD/p1XI+0I8TQCqoPxVpnqo/4RDR
    OO0xcT/2bzqawcj0QBvKcXsGSmFAEhwwww3ToD//iRlgPRtYQAYYnnPz7aNABN4kwatbjkAE
    F7brQbWLQA9eb/t/VpFAIBGkoPh3ZD/bH0nokoxFQCBLwL0wMt9AAYPrkyVQCkAeiPh58Soc
    QAG4Dm7hPM9AE3xqQ7gIET/wvdPn0b6CQA1so/7EuPk/82CjcqUn3EAA/aDaGYBIQACR0jGZ
    MspALWd7VjeaIEAFdVdMBgG8QEDVGESaY8QAAAAOAAAAyEAqZmZmZmZmQDIAAAAAAABAHTMz
    MzMzM0AEzMzMzMzNQA8zMzMzMzNAKgAAAAAAAEAmAAAAAAAAQCgAAAAAAABAMAAAAAAAAEAs
    zMzMzMzNQAszMzMzMzNAHmZmZmZmZkACZmZmZmZmQBAAAAAAAABANgAAAAAAAEAUZmZmZmZm
    QDKzMzMzMzNAHAAAAAAAAEAVmZmZmZmaQBAAAAAAAABAEAAAAAAAAEAtmZmZmZmaQDQzMzMz
    MzNALjMzMzMzM0AqAAAAAAAAQC8zMzMzMzNAMgAAAAAAAEAyszMzMzMzQChmZmZmZmZAHgAA
    AAAAAEA3AAAAAAAAQBpmZmZmZmZAEAAAAAAAAEACZmZmZmZmQCIAAAAAAABAHTMzMzMzM0AJ
    mZmZmZmaQDAzMzMzMzNAI5mZmZmZmkA3AAAAAAAAQC6ZmZmZmZpANQAAAAAAAEAtZmZmZmZm
    QCvMzMzMzM1AEAAAAAAAAEAyGZmZmZmaQBgAAAAAAABAEszMzMzMzUAfMzMzMzMzQCZmZmZm
    ZmZAJczMzMzMzUAOZmZmZmZmQDdMzMzMzM1AJwAAAAAAAEAxMzMzMzMzQDEAAAAAAABADmZm
    ZmZmZkAoAAAAAAAAQCYAAAAAAABAMAAAAAAAAEAUAAAAAAAAQCQAAAAAAABAKAAAAAAAAEAo
    AAAAAAAAQDQAAAAAAABALAAAAAAAAEAdMzMzMzMzQAQAAAAAAABAJQAAAAAAAEARmZmZmZma
    QCZmZmZmZmZAKszMzMzMzUAsAAAAAAAAQC0zMzMzMzNAMzMzMzMzM0AkAAAAAAAAQBQAAAAA
    AABAE5mZmZmZmkAiZmZmZmZmQC+ZmZmZmZpAMgAAAAAAAEA4AAAAAAAAQC9mZmZmZmZALgAA
    AAAAAEA3AAAAAAAAQDMAAAAAAABAAzMzMzMzM0AcAAAAAAAAQDPmZmZmZmZANAAAAAAAAEAb
    MzMzMzMzQDUAAAAAAABAIgAAAAAAAEAdmZmZmZmaQB4AAAAAAABAGmZmZmZmZkAsAAAAAAAA
    QDEAAAAAAABALDMzMzMzM0AoAAAAAAAAQCpmZmZmZmZAMgAAAAAAAEAdMzMzMzMzQATMzMzM
    zM1ADzMzMzMzM0AqAAAAAAAAQCYAAAAAAABAKAAAAAAAAEAwAAAAAAAAQCzMzMzMzM1ACzMz
    MzMzM0AeZmZmZmZmQAJmZmZmZmZAEAAAAAAAAEA2AAAAAAAAQBRmZmZmZmZAMrMzMzMzM0Ac
    AAAAAAAAQBWZmZmZmZpAEAAAAAAAAEAQAAAAAAAAQC2ZmZmZmZpANDMzMzMzM0AuMzMzMzMz
    QCoAAAAAAABALzMzMzMzM0AyAAAAAAAAQDKzMzMzMzNAKGZmZmZmZkAeAAAAAAAAQDcAAAAA
    AABAGmZmZmZmZkAQAAAAAAAAQAJmZmZmZmZAIgAAAAAAAEAdMzMzMzMzQAmZmZmZmZpAMDMz
    MzMzM0AjmZmZmZmaQDcAAAAAAABALpmZmZmZmkA1AAAAAAAAQC1mZmZmZmZAK8zMzMzMzUAQ
    AAAAAAAAQDIZmZmZmZpAGAAAAAAAAEASzMzMzMzNQB8zMzMzMzNAJmZmZmZmZkAlzMzMzMzN
    QA5mZmZmZmZAN0zMzMzMzUAnAAAAAAAAQDEzMzMzMzNAMQAAAAAAAEAOZmZmZmZmQCgAAAAA
    AABAJgAAAAAAAEAwAAAAAAAAQBQAAAAAAABAJAAAAAAAAEAoAAAAAAAAQCgAAAAAAABANAAA
    AAAAAEAsAAAAAAAAQB0zMzMzMzNABAAAAAAAAEAlAAAAAAAAQBGZmZmZmZpAJmZmZmZmZkAq
    zMzMzMzNQCwAAAAAAABALTMzMzMzM0AzMzMzMzMzQCQAAAAAAABAFAAAAAAAAEATmZmZmZma
    QCJmZmZmZmZAL5mZmZmZmkAyAAAAAAAAQDgAAAAAAABAL2ZmZmZmZkAuAAAAAAAAQDcAAAAA
    AABAMwAAAAAAAEADMzMzMzMzQBwAAAAAAABAM+ZmZmZmZkA0AAAAAAAAQBszMzMzMzNANQAA
    AAAAAEAiAAAAAAAAQB2ZmZmZmZpAHgAAAAAAAEAaZmZmZmZmQCwAAAAAAABAMQAAAAAAAEAs
    MzMzMzMzQCgAAAAAAAAAAAMNAAAAyAAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAAB
    AAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAA
    AAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAAB
    AAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAA
    AAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAAB
    AAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAA
    AAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAAB
    AAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAACAAAAAgAA
    AAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAAC
    AAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAA
    AAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAAC
    AAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAA
    AAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAAC
    AAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAA
    AAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAAC
    AAAAAgAAAAIAAAACAAAEAgAAAAEABAAJAAAABmxldmVscwAAABAAAAACAAQACQAAAAhIbHlF
    X0lnQQAEAAkAAAAISGx5RV9JZ0cAAAQCAAAAAQAEAAkAAAAFY2xhc3MAAAAQAAAAAQAEAAkA
    AAAGZmFjdG9yAAAA/gAABAIAAAABAAQACQAAAAVuYW1lcwAAABAAAAADAAQACQAAAAV2YWx1
    ZQAEAAkAAAADYWdlAAQACQAAAAthbnRpZ2VuX2lzbwAABAIAAAABAAQACQAAAAlyb3cubmFt
    ZXMAAAANAAAAAoAAAAD///84AAAEAgAAAv8AAAAQAAAABAAEAAkAAAAIcG9wX2RhdGEABAAJ
    AAAABnRibF9kZgAEAAkAAAADdGJsAAQACQAAAApkYXRhLmZyYW1lAAAEAgAAAAEABAAJAAAA
    DGFudGlnZW5faXNvcwAAABAAAAACAAQACQAAAAhIbHlFX0lnQQAEAAkAAAAISGx5RV9JZ0cA
    AAQCAAAAAQAEAAkAAAAHYWdlX3ZhcgAAABAAAAABAAQACQAAAANhZ2UAAAQCAAAAAQAEAAkA
    AAAJdmFsdWVfdmFyAAAAEAAAAAEABAAJAAAABXZhbHVlAAAEAgAAAAEABAAJAAAABmlkX3Zh
    cgAAABAAAAABAAQACQAAAAJpZAAABAIAAAABAAQACQAAAA1iaW9tYXJrZXJfdmFyAAAAEAAA
    AAEABAAJAAAAC2FudGlnZW5faXNvAAAA/gAAAxMAAAAEAAAADgAAAMhAT72fHFoRlUBkfI/P
    FIyRQHICl9FibVVAYzQgFKtH90B6/RvjnERyQGHuklz/faZAPo1mmm1j7kBKp3R0awpaQGQH
    8+QyLYJAgWh2HS7WMUCAZgCX/oPzQI3peMg6iBNAPsaUcFQgkUCFxxXfhuJ9QESq5WEITD5A
    SNkgg8j0jUBvDoMSIpZcQHHD0V9wkLNAc/QhIaPCcEBLmUFmSwvFQCO2OVBpclNAYc9wjqSg
    z0BNSNeVriVQQF9GnzlYuClAN5QAr06zgUBjRFB3wrFvQGhotPJlvA9AgAV8YnwKHUAuen4X
    70qYQHb6zvAi8FlAYVMhidla30BXg3zrKln5QDGzREs6FJhAekhT6ARAEkBBUJvRqr5KQF1H
    dRl4tTdAhPZCRAckbkBhd9OHaCEXQHXmOrfUqLtAcYxewNDBCUCAZnEPVv1kQHVeAejGeMtA
    Nb3yceK5wkCJP8nl6ro8QEtTBFiVNZRAZCRxeKIF6EBPOzeQipyGQHWQM2a/Z61AKw2DHkIW
    +kBx+UiguMcWQHlKRJJxv1BAdJoD6bKvxkBf3XH09lsQQF3stq4Cdl9AR9ZRFsfwYkBKq99r
    vda8QBNzQdg0WY1AV2c6o9ZflEBrKGOw8egJQEuOdYsRDitAQYybp9NqI0BdpEJyrhOhQJEp
    /RiKvaJASw3SiQ/LS0BNe0C+tf4ZQGD+efjSFpNARQ3oVmyo4EBwSYa3ETSEQEFgxSg9pRNA
    cBZ9pg+6+UBmYe41pUO/QGM2OQnPn/JAOKq4t4ZYEEBIuOX6UpjDQIH3KEsV8ztAWmvG6xSa
    F0AwjRGiavv8QE4aIpxgGrVAJhc6NH7ATUB863kWJ6crQHSXNZ8Qna9Ad+jRhoh5gUBgx3Rg
    E9aaQG3uw8HTreJALL5recUS0EBwiXEobdFiQERXEpimABpATMHX9RfspkBWEZUpN3JEQHrl
    GyN3cuVAJTnd1WqXOkCBcOy8JouvQEABu7j/b0xAOAnatfx5D0BDBnR3ngG4QFN4j7QZ9yNA
    X7SChCUhLUBj/WctUHXwQFF5lUWlD0JAcG4gSRFA2EB2KIY/IyntQHnK0t9djYpAXLsSi2pw
    E0BeN+bcXDbTQGCTNSzJjklAWd32wv8rMkB78BjfiLjsQJD04ef/eoxAQMKx9QegwkBvpEin
    ioN2QGBYOcmN08ZAULr/A6nDVUB3aVHP/Sh1QGFxLlMbL7BAQ7MNJvNak0BYOqir14FGQGZ9
    bNvM+PtAl1eHloJ7oEAtmg7OuZkoQHlNbnTXk3hAgKWoVyXfOEBHOrfV8g/4QDh8X4q6eURA
    SLtrinyHiUBXwXQifHq1QFd+BQ3d6kNAcELRMK/fsUBhv6fYO6PXQEP9GoqictBAiHeiklGz
    SEA9aSRauexDQIAlKiqmGZtAanJPznm0mECceNoziZG4QEpBQXQ1JYVAKk1TMiHIV0AzYr45
    FuwXQEGe1luc3H5AVD3/fW6BGkBmJYvNvDnoQDpdU4JozhhAXU5mllC3uUBVwaxodf2/QF+8
    1pPC87FAOzVVfJYm+0BU9IqIX4/6QFBdmP5qoWdATkuztqIhGUBJQ/72c+fQQGuM6JiR3zZA
    TPDU0PAkNUB0FW1wKdPgQFwVLy3/2C9AasOszbAxQEBHIhZIdwh8QG+izlgM5YxAUvlH0qSE
    kUB2y1FoU8CVQDXtgU7pxUFAdWD4RPvAVEBSOIDJSvTVQESwbK0AlyVARhh4VXcWZEBSr1HJ
    k2YnQElqA+mDRdFAcJcZ53t8KEBsh/+2j/W7QGLHDxFPiaZAYTd4+/LBJUBxoU4Ia7bgQGww
    M01rlqBAPzA0BBNU7kBkchfaeMGLQGbJ/UE1e0NAfUF79WwZ5EA68sVtFqlyQEeICXsjXjpA
    cJmGD4qLGEAmV0S+7cBKQGWBVIXeSLVAZCItfxaAlkB7CEMwGt0VQFZPJQabw6dAV0QUvNF2
    lkCLGwv8JSrzQHksEbEhao5AMeEUoHXOx0ByDn2a+oEsQDXo5mOwpsRASGwbwljNgEA12TCF
    N2kwQGbyY3clVoFARWwrGBEaVkB4hyH4p2YVQCbJdmhqdzBAdDi7gkz8CkBeFCnVHBbOQGSM
    7vC0Lm5AbzGh+/Gw90BEukzrZQNcAAAADgAAAMg/QwevXGZlQT9yuzbHJluwPz4c1bjXWwo/
    Tipb4KL7rD8yK9wO/xxMP2gONMEFy2M/VMaB4p3WjD8oQXY8Y1zeP1bmTdA9KCc/QI/xddMN
    XT8zRb0aaYVYP0VzxBaI0dw/ctBPrXD1Bz9NFnfmNybyP2MnVasUCU4/K4IVqK3uCT8IfAIK
    XYAoP1EKOhjUnhU/PWE1zvkZaD8rMKjZSRl/P1415UWTJKo/QcC8sB7tZj8lwG+hgqleP2pk
    111T4Rc/SkRhiAGVuD9TM2XYgjf0P2FjKdg/cyI/UAHE4PZZrD9g5AUbOV83Pzk0LGwMGXw/
    QRGX0AhvPD9QfaLGkuVBP1IblhpDfaE/KAMAHw5sqT9Agwf0v/h3Py3rQFP4Pls/X9KI+wZi
    Vj8meqCGJTFUPzg6d3Q9q/Y/US3hYKubdD9G2JXxayNuPzRoLQTiNHc/NzgWcLFn6j9UaP0v
    XHidPzvIhe09mEY/SkFsQ3wLfT9TxDvcKhI2P2N6G3qDPOQ/VEB/DjEV1z83dllPagWSP0Ax
    J1pKGTc/JHKRS32YHD9kH/OAhBmVP0uTC7OwWRM/X8DgUvc0sz9ASjl5izjMP3ZBOFBLkJc/
    VNvFRhKbFz9CEKVuUdEMP0TGpuShSDc/XJlogxDX0T84th6n6R6iPz+t1Mm2XrY/NipbGoZh
    vT9h+uUwpFQPP1b9gX+T8IE/UcjNG+CpgT9Q13F0csQaP2yZ8QBBtPY/Nxr5RbSODj9ajY2Q
    5kDXP2bsAnt+OJg/YA6q+Syr5j81qar34Ow1PzdRGvadb+4/PMLGsRAeCT9UXGl1BcZPP0Ic
    6vOcV6E/XqJh8yTRHz810/m5cLKwP1IVqBXcugg/V/rh39pD7T8iRCVWpDBWPzoHlMgVjy8/
    UrZk5spaLj9QbRPOrHkDP1Hg51Bx/GQ/VMcy5YrzuD9QLthCkJd5P1UiIK+khHg/Zx92MNWO
    +D84j/ZXMF/3P1Kn2nxyiTk/QXbbHlcCyD9A1Lc24TZZPzeOuVH5NEU/MhQmNB+tBT83Pt4m
    5AB8P2XiO/+pSh8/ZuJV4PzgLD8gzZaBA1Q4P3hzPLw+AyU/fOOMiwBrwD9gko3lZv+UP1qS
    225PBpE/OIbZ8L0xOT8xiLe2Y8IXP0fv0zLr/TI/WRjILj5PSz9qpjlVjGRzPz+1yGEx738/
    Q0dIRH1CwD8zjWYMIEOXP1Jzp3kkmQo/W6HDhSWPGT8q3dZPkKX7P1+uM4qv5Bw/V18fhR6u
    ZT9WC/EPKkQlPytgFVDen7w/RH337pmbQj9V3ZIW7r1pP4M5MZ+OfU8/TrVIjAxSnD9D8Jay
    5qOoP2Wk5F8/4ps/ObIKnsvKhz9rLpSgYclKP151fwysL/Q/TbjVX7gdbT9S48f+gFynPzAY
    bZTq0SQ/UcI0VXBuCD9ge7+ZLXVbP19Iu+Xx91I/Osung5wnbz9J7peFFVVqP2CBEZQJkQE/
    XBks3JxEcT9W9WOzayFFP1BzxM2xH2k/QQNqNmiJoT9bYTGfplcEP0t8fiyaoig/R6WkCpF1
    Yj9AjxhlmQ27P03NBg1RCGg/U9qZRuCblD9LGD1/nTI7P2f5Hp6XpmQ/M+6VeR9nHz9SrNKr
    t451PzmKsP/pl5g/aHN4UDDyxD9LkP+23tmiP24mxhWBx5g/O6VC+MnPNT9UUGKaRpPpP0js
    ledWpIk/WFbZfld3zz9LSyFCa/izPzOtYoDo4c4/X3NK/rd0AT853cx94V+fP2X0Ik/wEzI/
    WRl9HMl4qz9UAkuq5ShMPzhyCkSUv/U/VgG8P2x9cj9G3wXPmbyGP0kerWZop0E/MA8V1Y9P
    TD9Mmzfa3aT6P30rHLZIKh4/ChwUgiYhaj9PEuoH4dhGP0Eax1/Ftfs/VIw4G5QVwD9JlLjC
    4G5MP2DKSE6sGwc/CtYrEkfMuz92+02O1bXnP0qBCbF9nbI/R2AQSgbCZD9MKcpUtGuNP2Hi
    hMf/IUE/XY9sfpP13T9DTaclmB81P0OnKA76V1U/VjHiDNSwdz9Xd8OtXZ/GP0A4ClcQWys/
    Q+yOwSZY5z9yfvviqztlP2ugFhCOGkk/N8RkviIzyT8XkbS8Yts4PzeuOdkvfpc/MXxYiW7A
    Iz9pT9aIU0G0AAAADgAAAMg/++utAk4wSj/yyWVI6kTeQAVN1kHLSFQ/9MJ2u9ESFz/5xNSd
    dKRkP/IZU55KcBk//ewVVIAc+kABCAP/uRekP/Zb9qxDTJQ//5lXkNQVYEACFWuRT1U/P/vV
    EI9VJh8/+MY2EX+JmD/0oaZSOQOjP/eiSbSbCZQ/+b04N8a6eUAg/iVJQLWMP/OlVjtGI30/
    +/0jcZm8r0AAuV+4tK9cP/QGQnpwtJw/+l36iCqdPj/+DeuCD9xDP/KzZ8CMDHk/9GIh6yVv
    Xj/2wjqtISNGP/m5W6y2V1o/85QqKqmlmT/yKtDYRGBUP/c+xTWkov4//WXygEET2j/2KFhT
    HxIJP/VZ7oQsplBAAb6qZzdLREAHB0IRbyHmQAelqlcqMAo/9gtFb9gPcT/8mm6YndJ6QAtm
    4RCaQ6M/83ZGJWCyzz/3vzNLX9hTQAN66mv3ONY/9eMDdbeuLT/3qYK2TaIOP/hB3V2QrIw/
    8ydhozDhj0AGalF6VswhP/HHzjS/qcg/9MFOi0Hmlj/5HQEhsOfGP/aA1iFMhXNAACoWfoOu
    Dz/5XltfWJJ4P/UapHxkrlw/86rjUiZYGj/6h81ohXrQP/jxW+q6OPM/9C8rWYFZqT/2CH5I
    IkHTP/vpI0v6SZM/8zqc1IX7Az/3GTYBqiCuQAMUr8nmKB4//iAjltmopD/5shejO6MEP/WU
    KmrENXQ/+e5p5U0Sxz/0/Bpc9ZaqQAEC+7SJb7s/+ml+yuKr1j/3r5K6/AgyP/MyeDL4Q0hA
    AATbVlL2XD/7RyrbnDYLP/3uO60o/Cs/+r8nBVycdT/+wEVZkH/CP/nCxUwSF7w/9ZnNw3zw
    xEACETnoupCwP/bvBan+2H0/+O0sYPSd/EAS4t3C1sRGQASpn/d6z/I/9xyLC4hzij/zGD3N
    moWYQABKHqzwKHM/+ALk6Y+5HD/7SSGgew/gP/TsAvTz/4Q/9afDzYeE4kAA7XQ7qYJGP/7v
    XJ7ev2k/9oB8o0sG2j/6WtU4G0eZQAiQtKxlnHQ/+mLbFxQbUj/5Fv9oBNdqP/X9J8CR6Cg/
    9ST+IkSzHz/8J9IEv8boP/CDpLDQp20/8yOepa4//T/yAO2oV8cUQARhgyHghwA/+oGesq/d
    4T/9gGeNf3C2P/X94p7xLlY/9W977xpFjD/xs9p+qXsIQAGGcgYQ2qw/+SxWjenpwz/7D3Ph
    l6MEP/R2kiWtcLk/9wnhbd/xUkAMJXEih7bqP/d4KKnk7AY/9ZhT5JQkzj/3nTodLyVUP/xv
    skJGgkA//8nAVRboAj/z58LLaX8fP/LT5RXS2Gw/8/9Ed3fZGz/+67q7SovpP/RVEadNHQZA
    ATZo/I/zJD/xjv5xOnjNP/kJMqG7ark/9D+/35KuSz/36Cf4IVeQP/3kNVHswZE/+rI44+Z6
    Jj/yOGOaGFseQA8h8AwxvV9AAiaI4b+tYj//vHFYSbGhP/HPH+bUJMw/9NyCPpT1KD/x7x42
    1DNJP/VNr05NuCc//vON88UBdz/1/bK3rSpwP/lAUfJ1oOpAAvJ+cavERj/+gKEPFSSOP/to
    cdWqEDk/9vp1tHhlsEAC/CgfNW0KP/KRwDW+s5U//wjzGvYIVz/zTNBQsbCGP/PfotTxHck/
    8cNo+i0e/z/0ae+V1KPZP/JprWQYsAZAASzFEnOweD/0de5k4c1iQAHFmG85JKg/9KLJ2KsU
    6D/21kvDW58ZQAKWOD86qhw/+emxEyfROT/3mU8hjuFiP/iPr32tmhU/8+fpMDLuSD/zs5DK
    /u/1P//Ym5jw/lQ/+EjBrTEylz/1G6YmhW87P/nPC3J0VEI/9QihsS1zgT/2367xI1e0P/CS
    DjBF6UdAEzSO2XvuTj/2Mqp3hgQeP/jwJyLiX0Y/+G0zpMKCpUACUb1iImZ3P/JzvxAZVTNA
    GPQJAn+7AD/xlX+C6rYEP/qJ8OUQpNo/+AJUBjzH6j//TMbHE0lvP/J5JjTZRCs/94IBwpWQ
    Qz/2RHMlbTU4P/p25MV50kA/9Ex5UEANbEAFb6kHUTKeP/+3L5OX+b5AApO9sgqdzj/xeCFo
    q/j8QAErSS4SkJg//KrwRr737EAEhk9UlomSP/04raohR9NAAe6B3EFStj/yRs0ct8r4AAAD
    DQAAAMgAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIA
    AAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAA
    AgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEA
    AAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAA
    AQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIA
    AAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAA
    AgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEA
    AAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAA
    AQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIA
    AAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAA
    AgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEA
    AAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAA
    AQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIA
    AAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAA
    AgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAAAAEAAAACAAAAAQAAAAIAAAABAAAAAgAABAIA
    AAH/AAAAEAAAAAUABAAJAAAACEhseUVfSWdBAAQACQAAAAhIbHlFX0lnRwAEAAkAAAAHTFBT
    X0lnQQAEAAkAAAAHTFBTX0lnRwAEAAkAAAAGVmlfSWdHAAAEAgAAAv8AAAAQAAAAAQAEAAkA
    AAAGZmFjdG9yAAAA/gAABAIAAAP/AAAAEAAAAAQABAAJAAAAAnkxAAQACQAAAAVhbHBoYQAE
    AAkAAAABcgAEAAkAAAALYW50aWdlbl9pc28AAAQCAAAE/wAAAA0AAAACgAAAAP///zgAAAQC
    AAAC/wAAABAAAAAEAAQACQAAAAxjdXJ2ZV9wYXJhbXMABAAJAAAABnRibF9kZgAEAAkAAAAD
    dGJsAAQACQAAAApkYXRhLmZyYW1lAAAEAgAABf8AAAMNAAAABQAAAAEAAAACAAAAAwAAAAQA
    AAAFAAAEAgAAAf8AAAAQAAAABQAEAAkAAAAISGx5RV9JZ0EABAAJAAAACEhseUVfSWdHAAQA
    CQAAAAdMUFNfSWdBAAQACQAAAAdMUFNfSWdHAAQACQAAAAZWaV9JZ0cAAAQCAAAC/wAAABAA
    AAABAAQACQAAAAZmYWN0b3IAAAD+AAAEAgAACf8AAAAQAAAAAQAEAAkAAAALYW50aWdlbl9p
    c28AAAD+AAADEwAAAAUAAAAOAAAAAkAEw84ADRzoQALhYqLKYFgAAAAOAAAAAj/R4GSyElOY
    P8KkV93KZo8AAAAOAAAAAj/gRT3G12HJP/mDYcEyhzMAAAAOAAAAAkFTEtAAAAAAQVMS0AAA
    AAAAAAAQAAAAAgAEAAkAAAAISGx5RV9JZ0EABAAJAAAACEhseUVfSWdHAAAEAgAAA/8AAAAQ
    AAAABQAEAAkAAAACbnUABAAJAAAAA2VwcwAEAAkAAAAFeS5sb3cABAAJAAAABnkuaGlnaAAE
    AAkAAAALYW50aWdlbl9pc28AAAQCAAAE/wAAAA0AAAACgAAAAP////4AAAQCAAAC/wAAABAA
    AAAEAAQACQAAAAxub2lzZV9wYXJhbXMABAAJAAAABnRibF9kZgAEAAkAAAADdGJsAAQACQAA
    AApkYXRhLmZyYW1lAAAEAgAABf8AAAAQAAAABAAEAAkAAAAISGx5RV9JZ0EABAAJAAAACEhs
    eUVfSWdHAAQACQAAAAdMUFNfSWdBAAQACQAAAAdMUFNfSWdHAAAA/gAAABAAAAACAAQACQAA
    AAhIbHlFX0lnQQAEAAkAAAAISGx5RV9JZ0cAAAQCAAAD/wAAABAAAAAEAAQACQAAAAhwb3Bf
    ZGF0YQAEAAkAAAAJc3JfcGFyYW1zAAQACQAAAAxub2lzZV9wYXJhbXMABAAJAAAADGFudGln
    ZW5faXNvcwAABAIAAAL/AAAAEAAAAAIABAAJAAAAGWJpb21hcmtlcl9kYXRhX2FuZF9wYXJh
    bXMABAAJAAAABGxpc3QAAAD+AAAEAgAAA/8AAAAQAAAAAQAEAAkAAAAIYWxsIGRhdGEAAAQC
    AAAF/wAAABAAAAACAAQACQAAAAhIbHlFX0lnQQAEAAkAAAAISGx5RV9JZ0cAAAQCAAAAAQAE
    AAkAAAAGc3RyYXRhAAADEwAAAAEAAAAKAAAAAYAAAAAAAAQCAAAC/wAAABAAAAADAAQACQAA
    AAZ0YmxfZGYABAAJAAAAA3RibAAEAAkAAAAKZGF0YS5mcmFtZQAABAIAAAT/AAAADQAAAAKA
    AAAA/////wAABAIAAAP/AAAAEAAAAAEABAAJAAAAB1N0cmF0dW0AAAD+AAAA/g==

