% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{icon}
\alias{icon}
\title{Create an icon}
\usage{
icon(name, class = NULL, lib = "font-awesome", ...)
}
\arguments{
\item{name}{The name of the icon. A name from either \href{https://fontawesome.com/}{Font Awesome} (when \code{lib="font-awesome"}) or
\href{https://getbootstrap.com/docs/3.3/components/#glyphicons}{Bootstrap Glyphicons} (when
\code{lib="glyphicon"}) may be provided. Note that the \code{"fa-"} and
\code{"glyphicon-"} prefixes should not appear in name (i.e., the
\code{"fa-calendar"} icon should be referred to as \code{"calendar"}). A \code{name} of
\code{NULL} may also be provided to get a raw \verb{<i>} tag with no library attached
to it.}

\item{class}{Additional classes to customize the style of an icon (see the
\href{https://fontawesome.com/how-to-use}{usage examples} for details on
supported styles).}

\item{lib}{The icon library to use. Either \code{"font-awesome"} or \code{"glyphicon"}.}

\item{...}{Arguments passed to the \verb{<i>} tag of \link[htmltools:builder]{htmltools::tags}.}
}
\value{
An \verb{<i>} (icon) HTML tag.
}
\description{
Create an icon for use within a page. Icons can appear on their own, inside
of a button, and/or used with \code{\link[=tabPanel]{tabPanel()}} and \code{\link[=navbarMenu]{navbarMenu()}}.
}
\examples{
# add an icon to a submit button
submitButton("Update View", icon = icon("redo"))

navbarPage("App Title",
  tabPanel("Plot", icon = icon("bar-chart-o")),
  tabPanel("Summary", icon = icon("list-alt")),
  tabPanel("Table", icon = icon("table"))
)
}
\seealso{
For lists of available icons, see \url{https://fontawesome.com/icons}
and \url{https://getbootstrap.com/docs/3.3/components/#glyphicons}
}
