% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-input.R
\name{updateTabsetPanel}
\alias{updateTabsetPanel}
\alias{updateNavbarPage}
\alias{updateNavlistPanel}
\title{Change the selected tab on the client}
\usage{
updateTabsetPanel(
  session = getDefaultReactiveDomain(),
  inputId,
  selected = NULL
)

updateNavbarPage(
  session = getDefaultReactiveDomain(),
  inputId,
  selected = NULL
)

updateNavlistPanel(
  session = getDefaultReactiveDomain(),
  inputId,
  selected = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}. Default is \code{getDefaultReactiveDomain()}.}

\item{inputId}{The id of the \code{tabsetPanel}, \code{navlistPanel},
or \code{navbarPage} object.}

\item{selected}{The \code{value} (or, if none was supplied, the \code{title})
of the tab that should be selected by default. If \code{NULL}, the first
tab will be selected.}
}
\description{
Change the selected tab on the client
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(sidebarLayout(
  sidebarPanel(
    sliderInput("controller", "Controller", 1, 3, 1)
  ),
  mainPanel(
    tabsetPanel(id = "inTabset",
      tabPanel(title = "Panel 1", value = "panel1", "Panel 1 content"),
      tabPanel(title = "Panel 2", value = "panel2", "Panel 2 content"),
      tabPanel(title = "Panel 3", value = "panel3", "Panel 3 content")
    )
  )
))

server <- function(input, output, session) {
  observeEvent(input$controller, {
    updateTabsetPanel(session, "inTabset",
      selected = paste0("panel", input$controller)
    )
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link[=tabsetPanel]{tabsetPanel()}}, \code{\link[=navlistPanel]{navlistPanel()}},
\code{\link[=navbarPage]{navbarPage()}}
}
