% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arg_name_input.R
\name{arg_name_input_generics}
\alias{arg_name_input_generics}
\alias{arg_name_input_id}
\alias{arg_name_input_label}
\alias{arg_name_input_value}
\title{Determine Filter Input Argument Names}
\usage{
arg_name_input_id(x, ...)

arg_name_input_label(x, ...)

arg_name_input_value(x, ...)
}
\arguments{
\item{x}{The object called by \code{\link[=filterInput]{filterInput()}}.}

\item{...}{Additional arguments passed to methods.}
}
\value{
\itemize{
\item \code{arg_name_input_id()}: Always returns \code{"inputId"}
\item \code{arg_name_input_label()}: Always returns \code{"label"}
\item \code{arg_name_input_value()}: Returns the appropriate argument name(s):
\itemize{
\item character: \code{"selected"} (default), or \code{"value"} ()\code{textbox = TRUE})
\item Date: \code{"value"} (default), or \code{c("start", "end")} (\code{range = TRUE})
\item factor/list/logical: \code{"selected"}
\item numeric: \code{"value"}
\item POSIXt: dispatches to Date method
\item data.frame: list of values for each column
}
}
}
\description{
Generics that determine the appropriate argument names for filter input
functions based on the type of object being filtered. These generics
dispatch on \code{x} and return the \pkg{shiny} input argument name(s) used
internally by \pkg{shinyfilters}.
}
\keyword{internal}
