% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.theta_target.R
\name{summary.theta_target}
\alias{summary.theta_target}
\title{Method for the summary of the STF}
\usage{
\method{summary}{theta_target}(object, ...)
}
\arguments{
\item{object}{Object of class \code{theta_target}}

\item{...}{other arguments}
}
\value{
A summary of the STF obtained from the application of the \eqn{\theta} target procedure
}
\description{
The STF is obtained with the \eqn{\theta} target procedure implemented in the function \code{theta_target()}
}
\examples{
set.seed(123)
n <- 50
theta <- rnorm(500)
item_par <- data.frame(
  b = runif(n, -3, 3),
  a = runif(n, 1.2, 1.9),
  c = rep(0, n),
  e = rep(1, n)
)
targets <- define_targets(theta, num_targets = 4)
resT <- theta_target(targets, item_par)
summary(resT)
}
