% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-test_classifier.R
\name{lqas_simulate_population}
\alias{lqas_simulate_population}
\alias{lqas_simulate_run}
\alias{lqas_simulate_runs}
\alias{lqas_simulate_test}
\title{Simulate survey data of covered/cases and non-covered/non-cases given
a coverage/prevalence proportion}
\usage{
lqas_simulate_population(proportion, pop)

lqas_simulate_run(proportion, pop, n, dLower, dUpper)

lqas_simulate_runs(
  pop,
  n,
  dLower,
  dUpper,
  pLower = 0,
  pUpper = 1,
  fine = 0.01,
  runs = 50,
  cores = parallelly::availableCores(omit = 1)
)

lqas_simulate_test(
  pop,
  n,
  dLower,
  dUpper,
  pLower = 0,
  pUpper = 1,
  fine = 0.01,
  runs = 50,
  replicates = 20,
  cores = parallelly::availableCores(omit = 1)
)
}
\arguments{
\item{proportion}{A numeric value of a coverage/prevalence proportion to
simulate on. Values should be between 0 and 1.}

\item{pop}{Population size from which simulated coverage survey data is to
be taken from.}

\item{n}{Sample size of actual or test coverage data.}

\item{dLower}{A numeric value for the lower classification threshold
proportion. Value should be between 0 and 1.}

\item{dUpper}{A numeric value for the upper classification threshold
proportion. Value should be between 0 and 1.}

\item{pLower}{Starting proportion for simulations. Default is 0.}

\item{pUpper}{Ending proportion for simulations. Default is 1.}

\item{fine}{Granularity of simulated proportions. Default is 0.01.}

\item{runs}{Number of simulation runs to perform per coverage proportion.
Default is 50 runs.}

\item{cores}{The number of computer cores to use/number of child processes
will be run simultaneously.}

\item{replicates}{Number of replicate LQAS simulations to perform.
Default is set to 20 replicates.}
}
\value{
A data.frame with 2 variables: \code{id} for unique identifier and \code{case}
for numeric vector of cases and non-cases (1s and 0s)

A data.frame with variable \code{cases} for total number of
covered/cases, \code{outcome} for LQAS outcome, and \code{proportion} for the
coverage/prevalence proportion being simulated on. For
\verb{[lqas_simulate_test()]}, a `sleac`` class object.
}
\description{
Simulate survey data of covered/cases and non-covered/non-cases given
a coverage/prevalence proportion

Perform LQAS on simulated data based on specified decision rules
}
\examples{
lqas_simulate_population(proportion = 0.3, pop = 10000)

lqas_simulate_run(
  proportion = 0.3, pop = 10000, n = 40, dLower = 0.6, dUpper = 0.9
)

lqas_simulate_runs(
  pop = 10000, n = 40, dLower = 0.6, dUpper = 0.9, runs = 10
)

lqas_simulate_test(
  pop = 10000, n = 40, dLower = 0.6, dUpper = 0.9, runs = 5, replicates = 5
)

}
