% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-snic.R
\name{internal_snic}
\alias{internal_snic}
\alias{.snic_new}
\alias{.snic_check}
\alias{.snic_seg}
\alias{.snic_means}
\alias{.snic_centroids}
\alias{.snic_animation}
\alias{.snic_core}
\title{Internal SNIC helpers}
\usage{
.snic_new(seg)

.snic_check(x)

.snic_seg(x)

.snic_means(x)

.snic_centroids(x)

.snic_animation(
  x,
  seeds,
  file_path,
  n_cycles,
  delay,
  progress,
  plot_args,
  snic_args,
  device_args
)

.snic_core(arr, seeds_rc, compactness)
}
\description{
Developer-facing utilities wrapping the SNIC container metadata and the
native segmentation entry point.
}
\section{Functions}{

\itemize{
  \item \code{.snic_new(seg)} Packs the segmentation array and
    metadata into an S3 container.
  \item \code{.snic_check(x)} Validates \code{snic} objects before
    accessing their slots.
  \item \code{.snic_seg(x)}, \code{.snic_means(x)},
    \code{.snic_centroids(x)} Accessors returning the segmentation map,
    feature means, and centroids respectively.
  \item \code{.snic_animation(...)} Internal driver used by
    \code{snic_animation()} to orchestrate frame generation.
  \item \code{.snic_core(arr, seeds_rc, compactness)} Thin wrapper
    around the native \code{snic_snic} routine that performs the actual
    clustering.
}
}

\keyword{internal}
