% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{getSigmoid}
\alias{getSigmoid}
\title{Get sigmoid filter}
\usage{
getSigmoid(len, samplingRate = 16000, freq = 5, shape = 0, spikiness = 1)
}
\arguments{
\item{len}{the length of output vector}

\item{samplingRate}{the sampling rate of the output vector, Hz}

\item{freq}{the frequency of amplitude modulation, Hz (numeric vector)}

\item{shape}{0 = ~sine, -1 = clicks, +1 = notches (NB: vice versa in
soundgen!); numeric vector of length 1 or the same length as \code{freq}}

\item{spikiness}{amplifies the effect of the "shape" parameter;
numeric vector of length 1 or the same length as \code{freq}}
}
\value{
Returns a vector of length \code{len} and range from 0 to 1
}
\description{
Internal soundgen function.
}
\details{
Produces a filter for amplitude modulation ranging from clicks to
approximately a sine wave to reversed clicks (small episodes of silence). The
filter is made from concatenated sigmoids and their mirror reflections.
}
\examples{
par(mfrow = c(3, 2))
for (shape in c(0, -.1, .1, .5, -1, 1)) {
  s = soundgen:::getSigmoid(shape = shape, len = 1000, samplingRate = 500, freq = 2)
  plot(s, type = 'l', main = paste('shape =', shape), xlab = '', ylab = '')
}
par(mfrow = c(1, 1))

par(mfrow = c(3, 2))
for (shape in c(0, -.1, .1, .5, -1, 1)) {
  s = soundgen:::getSigmoid(shape = shape, len = 1000, samplingRate = 500, freq = 2,
    spikiness = 3)
  plot(s, type = 'l', main = paste('shape =', shape), xlab = '', ylab = '')
}
par(mfrow = c(1, 1))
}
\keyword{internal}
