% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundgen_utilities.R
\name{addPitchJumps}
\alias{addPitchJumps}
\title{Add pitch jumps}
\usage{
addPitchJumps(pitch, magn, nj = 1, prop = 0.1, plot = FALSE)
}
\arguments{
\item{pitch}{numeric vector of f0 values over time (any step is OK)}

\item{magn}{magnitude of jump(s) in semitones, a numeric vector of length 1
or nj}

\item{nj}{number of jump pairs = affected segments (e.g., a single fragment
is transposed if nj = 1)}

\item{prop}{duration of transposed episode(s) a a proportion of the total
voiced duration (length of \code{pitch})}

\item{plot}{if TRUE, plots the original and modified contours}
}
\description{
Internal soundgen function
}
\details{
Adds random discontinuities (jumps) to a pitch contour in a manner that
shifts a segment of pitch contour up or down. Careful when adding several
jumps: one can land on top of another, and it gets rather weird rather
quickly.
}
\examples{
pitch = getSmoothContour(c(100, 350, 320, 110), len = 100, interpol = 'loess')
addPitchJumps(pitch, magn = runif(1, 3, 12), plot = TRUE)
addPitchJumps(pitch, magn = c(6, 1), nj = 2, plot = TRUE)
addPitchJumps(pitch, magn = 3, nj = 5, plot = TRUE)

pitch2 = c(rep(NA, 10), pitch[1:50], rep(NA, 25), pitch[51:100], rep(NA, 17))
addPitchJumps(pitch2, magn = c(6, 1), nj = 2, plot = TRUE)
}
