% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps.R
\name{formant_app}
\alias{formant_app}
\title{Interactive formant tracker}
\usage{
formant_app(...)
}
\arguments{
\item{...}{presets like \code{windowLength = 25}. Full list:
samplingRate_mult, nFormants, minformant, maxbw, dynamicRange_lpc, zp_lpc,
spec_ylim, dynamicRange, specContrast, specBrightness, blur_freq,
blur_time, reass_cex, zp, spec_maxPoints, osc_maxPoints, spectrum_smooth,
spectrum_xlim, spectrum_len, silence, windowLength_lpc, step_lpc,
windowLength, step, spectrum_xlim, spec_ylim, spec_colorTheme, osc, wn,
wn_lpc, vtl_method, speedSound, coeffs, interceptZero, tube}
}
\value{
A list of the last used settings ($settings) plus a data.frame with
  the formant measurements. Every time a new annotation is added, the app
  creates a backup csv file and creates or updates a global object called
  "my_formants", which contains all the annotations.
}
\description{
Starts a shiny app for manually correcting formant measurements. For more
tips, see \code{\link{pitch_app}} and http://cogsci.se/soundgen.html.
}
\details{
Suggested workflow: load one or several audio files (wav/mp3), preferably not
longer than a minute or so. Select a region of interest in the spectrogram -
for example, a sustained vowel with clear and relatively steady formants.
Double-click within the selection to create a new annotation (you may add a
text label if needed). If you are satisfied with the automatically calculated
formant frequencies, proceed to the next region of interest. If not, there
are 4 ways to adjust them: (1) type in the correct number in one of the
formant boxes in the top right corner; (2) click a spectrogram within
selection (pick the formant number to adjust by clicking the formant boxes);
(3) single-click the spectrum to use the cursor's position, or (4)
double-click the spectrum to use the nearest spectral peak. When done with a
file, move on to the next one in the queue. Use the orange button to download
the results. To continue work, upload the output file from the previous
session together with the audio files (you can rename it, but keep the .csv
extension). Use hotkeys (eg spacebar to play/stop) and avoid working with
very large files.
}
\examples{
\dontrun{
f = formant_app()  # runs in default browser such as Firefox or Chrome

f1 = formant_app(specType = 'reassigned', windowLength = 5, step = 1)
# full list of parameters that can be passed to formant_app():
# paste0(c(names(input)[which(names(input) \%in\% rownames(def_form))],
# 'spectrum_xlim', 'spec_ylim', 'spec_colorTheme', 'osc', 'wn', 'wn_lpc',
# 'vtl_method', 'speedSound', 'coeffs', 'interceptZero', 'tube'), collapse = ', ')

# run the app with previously used settings
f2 = do.call(formant_app, f1$settings)

# save the complete output, including the settings used
saveRDS(f2, 'my_formant_analysis.rds')

# To change system default browser, run something like:
options('browser' = '/usr/bin/firefox')  # path to the executable on Linux
}
}
\seealso{
\code{\link{pitch_app}}
}
