% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{rnorm_truncated2}
\alias{rnorm_truncated2}
\title{Random draw from a truncated normal distribution}
\usage{
rnorm_truncated2(
  n = 1,
  mean = 0,
  sd = 1,
  low = NULL,
  high = NULL,
  roundToInteger = FALSE,
  invalidArgAction = c("adjust", "abort", "ignore")[1]
)
}
\arguments{
\item{n}{the number of values to return}

\item{mean}{the mean of the normal distribution from which values are
generated (vector of length 1 or n)}

\item{sd}{the standard deviation of the normal distribution from which values
are generated (vector of length 1 or n)}

\item{low, high}{exclusive lower and upper bounds (both of length 1)}

\item{roundToInteger}{boolean vector of length 1 or n. If TRUE, the
corresponding value is rounded to the nearest integer.}
}
\value{
A vector of length n.
}
\description{
A simplified version of \code{rnorm_truncated}, in which values outside the
bounds are simply reset to the low/high bounds. The shape of the resulting
distribution is no longer Gaussian, but this is obviously much faster. Unlike
in \code{rnorm_truncated}, "low" and "high" should be scalars, not vectors
(ie static boundaries).
}
\examples{
hist(soundgen:::rnorm_truncated2(n = 100, mean = 10, sd = 5, low = 7, high = NULL,
  roundToInteger = c(TRUE, FALSE, FALSE)))
hist(soundgen:::rnorm_truncated2(n = 100, mean = c(10, 50, 100), sd = c(5, 0, 20),
  roundToInteger = TRUE)) # vectorized
# in case of conflicts between mean and bounds, either sample at random
# between the boundaries...
hist(soundgen:::rnorm_truncated2(n = 100, mean = 10, sd = .1,
  low = 10, high = 15, invalidArgAction = 'adjust'))
#... or ignore the boundaries
hist(soundgen:::rnorm_truncated2(n = 100, mean = 10, sd = .1,
  low = 15, high = 100, invalidArgAction = 'ignore'))
soundgen:::rnorm_truncated2(n = 6, mean = c(0, 0, 0, 0, 0, 3),
  sd = .05, low = 0, high = 6)
}
\keyword{internal}
