% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{run_both_methods}
\alias{run_both_methods}
\title{Run Both Methods and Compare}
\usage{
run_both_methods(
  sim_data,
  sim_metadata,
  model_code,
  nimble_params,
  output_dir,
  norm_idx_x,
  pois_idx_x,
  binom_idx_x,
  norm_idx_y,
  pois_idx_y,
  binom_idx_y,
  dist_y,
  outcome_type
)
}
\arguments{
\item{sim_data}{List of data elements to be used in the ABRM, structured like the output from the simulate_misaligned_data() function. The first element of this list is the Y-grid sf dataframe (named 'gridy'), containing a numeric area ID variable named 'ID_y', covariates named 'covariate_y_1','covariate_y_2',...., and an outcome named 'y'. The second element of this list is the X-grid sf dataframe (named 'gridx'), containing a numeric area ID variable named 'ID_x' and covariates named 'covariate_x_1','covariate_x_2',... The third element of the list is the atom sf dataframe (named 'atoms'), which should contain variables named 'ID_x' and 'ID_y' holding the X-grid and Y-grid cell IDs for each atom, as well as an atom-level population count named 'population'.}

\item{sim_metadata}{Simulation metadata}

\item{model_code}{NIMBLE model code}

\item{nimble_params}{List of NIMBLE parameters (niter, nburnin, thin, nchains)}

\item{output_dir}{Output directory}

\item{norm_idx_x}{Indices of normal X covariates}

\item{pois_idx_x}{Indices of Poisson X covariates}

\item{binom_idx_x}{Indices of binomial X covariates}

\item{norm_idx_y}{Indices of normal Y covariates}

\item{pois_idx_y}{Indices of Poisson Y covariates}

\item{binom_idx_y}{Indices of binomial Y covariates}

\item{dist_y}{Distribution type for outcome (1=normal, 2=poisson, 3=binomial)}

\item{outcome_type}{Outcome distribution name}
}
\value{
List with combined comparison, ABRM results, and dasymetric results
}
\description{
Runs both ABRM and dasymetric mapping methods and compares results
}
