% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_importance.R
\name{plot_importance}
\alias{plot_importance}
\title{Visualize variable importance scores}
\usage{
plot_importance(
  model,
  fill.color = viridis::viridis(100, option = "F", direction = -1, alpha = 1, end = 0.9),
  line.color = "white",
  verbose = TRUE
)
}
\arguments{
\item{model}{Model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}. Alternatively, a data frame with variable importance scores (for internal use only).}

\item{fill.color}{Character vector of colors or a function generating a color palette. Accepts hexadecimal codes (e.g., \code{c("#440154FF", "#21908CFF", "#FDE725FF")}) or palette functions (e.g., \code{viridis::viridis(100)}). For single-run models, creates a continuous gradient. For repeated models, assigns discrete colors to variables. Default: \code{viridis::viridis(100, option = "F", direction = -1, alpha = 1, end = 0.9)}.}

\item{line.color}{Character string specifying the color of point borders (single-run models) or violin plot outlines (repeated models). Default: \code{"white"}.}

\item{verbose}{Logical. If \code{TRUE}, prints the plot to the graphics device. Default: \code{TRUE}.}
}
\value{
ggplot object that can be further customized or saved. The plot displays variable importance on the x-axis and variable names on the y-axis, ordered by importance (highest at top).
}
\description{
Creates a visualization of variable importance scores from models fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}. For single-run models (\code{\link[=rf]{rf()}}, \code{\link[=rf_spatial]{rf_spatial()}}), displays points ordered by importance. For repeated models (\code{\link[=rf_repeat]{rf_repeat()}}), displays violin plots showing the distribution of importance scores across model repetitions.
}
\details{
This function creates different visualizations depending on the model type:

\strong{Single-run models} (\code{\link[=rf]{rf()}}, \code{\link[=rf_spatial]{rf_spatial()}} without repetitions):
\itemize{
\item Displays points showing the importance value for each variable
\item Variables ordered top-to-bottom by importance (most important at top)
\item Point color represents importance magnitude using a continuous gradient
}

\strong{Repeated models} (\code{\link[=rf_repeat]{rf_repeat()}}, \code{\link[=rf_spatial]{rf_spatial()}} with repetitions):
\itemize{
\item Displays violin plots showing the distribution of importance across repetitions
\item Variables ordered top-to-bottom by median importance (most important at top)
\item The median line within each violin shows the center of the distribution
\item Width of violin reflects the density of importance values at each level
\item Each variable receives a distinct fill color
}

\strong{Importance metric:}

The x-axis shows permutation importance, which measures the increase in prediction error when a variable's values are randomly shuffled. Higher values indicate more important variables. Importance is computed on out-of-bag (OOB) samples, providing an unbiased estimate of variable contribution.

\strong{Spatial predictors:}

In \code{\link[=rf_spatial]{rf_spatial()}} models, all spatial predictors (MEMs or PCA factors) are grouped into a single category labeled "spatial_predictors" to simplify comparison with non-spatial predictors.

\strong{Note on violin plots:}

Violin plots display kernel density estimates. The median line shown is the median of the density estimate, which may differ slightly from the actual data median. However, variables are always ordered by the true median importance to ensure accurate ranking.

\strong{Cross-validated importance:}

This function does not plot results from \code{\link[=rf_importance]{rf_importance()}}. For cross-validated importance plots, access \code{model$importance$cv.per.variable.plot} after running \code{\link[=rf_importance]{rf_importance()}}.
}
\examples{
data(plants_rf, plants_rf_spatial)

# Plot importance from Random Forest model
plot_importance(plants_rf)

# Plot importance from Spatial Random Forest model
plot_importance(plants_rf_spatial)


}
\seealso{
\code{\link[=print_importance]{print_importance()}}, \code{\link[=get_importance]{get_importance()}}, \code{\link[=rf_importance]{rf_importance()}}

Other visualization: 
\code{\link{plot_evaluation}()},
\code{\link{plot_moran}()},
\code{\link{plot_optimization}()},
\code{\link{plot_residuals_diagnostics}()},
\code{\link{plot_response_curves}()},
\code{\link{plot_response_surface}()},
\code{\link{plot_training_df}()},
\code{\link{plot_training_df_moran}()},
\code{\link{plot_tuning}()}
}
\concept{visualization}
