% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_book.R
\name{code_book}
\alias{code_book}
\title{Generate an interactive variable codebook}
\usage{
code_book(x, values = FALSE, include_na = FALSE, title = "Codebook", ...)
}
\arguments{
\item{x}{A data frame or tibble.}

\item{values}{Logical. If \code{FALSE} (the default), displays a compact summary of the variable's values.
For numeric, character, date/time, labelled, and factor variables, up to four unique non-missing values are shown:
the first three values, followed by an ellipsis (\code{...}), and the last value.
Values are sorted when appropriate (e.g., numeric, character, date)
For factors, the levels are used directly and are not sorted.
For labelled variables, prefixed labels are displayed via \code{labelled::to_factor(levels = "prefixed")}.
If \code{TRUE}, all unique non-missing values are displayed.}

\item{include_na}{Logical. If \code{TRUE}, unique missing values (\code{NA}, \code{NaN}) are explicitly appended at the end of the \code{Values} summary
when present in the variable. This applies to all variable types.
If \code{FALSE} (the default), missing values are omitted from \code{Values} but still counted in the \code{NAs} column.}

\item{title}{Optional character string displayed as the table title in the Viewer.
Defaults to \code{"Codebook"}. Set to \code{NULL} to remove the title completely.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A \code{DT::datatable} object.
}
\description{
\code{code_book()} creates an interactive and exportable codebook summarizing all variables of a data frame.
It builds upon \code{\link[=varlist]{varlist()}} to provide an overview of variable names, labels,
classes, and representative values in a sortable, searchable table.

The output is displayed as an interactive \code{DT::datatable()} in the Viewer pane,
allowing filtering, column reordering, and export (copy, print, CSV, Excel, PDF)
directly.
}
\details{
\itemize{
\item The interactive \code{datatable} supports column sorting, searching, and
client-side export to various formats.
\item All exports occur client-side through the Viewer or Tab.
}
}
\section{Dependencies}{

Requires the following packages:
\itemize{
\item \strong{DT}
\item \strong{cli}
\item \strong{tools}
}
}

\examples{
\dontrun{
# Example with a built-in dataset
df <- head(mtcars)

# Launch the interactive codebook (opens in Viewer)
code_book(df)
}

}
\seealso{
\code{\link[=varlist]{varlist()}} for generating the underlying variable summaries.
}
