% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splinecopulaMLE.R
\name{spline.copula.MLE}
\alias{spline.copula.MLE}
\title{Maximum likelihood estimation for spline copula parameter matrix}
\usage{
spline.copula.MLE(U, V, E1 = 0.001, E2 = 0.001, R0 = NULL)
}
\arguments{
\item{U}{Numeric vector of length \eqn{n} with values in (0, 1).}

\item{V}{Numeric vector of length \eqn{n} with values in (0, 1).}

\item{E1}{Positive scalar specifying the convergence tolerance
for the outer EM iteration updating \eqn{R}.}

\item{E2}{Positive scalar specifying the convergence tolerance
for the inner iteration updating auxiliary parameters.}

\item{R0}{Optional 5x5 numeric matrix providing initial values
for \eqn{R}. If \code{NULL}, a data-driven initialization is used.}
}
\value{
A list containing:
\describe{
\item{R}{Estimated 5x5 spline copula parameter matrix.}
\item{R0}{Initial matrix used to start the algorithm.}
\item{convergence}{Matrix recording the iteration number and
corresponding log-likelihood values.}
}
}
\description{
Performs maximum likelihood estimation of the 5x5 spline copula
parameter matrix \eqn{R} using an EM-type algorithm based on
M-spline basis functions.
}
\details{
The algorithm alternates between updating the spline copula
parameter matrix and auxiliary parameters until convergence
criteria are satisfied.
}
\examples{
n <- 100
R <- matrix(c(1,0,0,0,0,
              0,2,0,0,0,
              0,0,2,0,0,
              0,0,0,2,0,
              0,0,0,0,1)/8, 5, 5, byrow = TRUE)
out <- spline.copula.simu(n, R = R)
fit <- spline.copula.MLE(out$U, out$V)

}
